/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.upgrader.v130;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.tools.datasource.dao.ProcessDefinitionDao;
import org.apache.dolphinscheduler.tools.datasource.dao.WorkerGroupDao;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerUpgrader;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class V130DolphinSchedulerUpgrader
implements DolphinSchedulerUpgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V130DolphinSchedulerUpgrader.class);
    @Autowired
    private DataSource dataSource;

    @Override
    public void doUpgrade() {
        this.updateProcessDefinitionJsonWorkerGroup();
    }

    private void updateProcessDefinitionJsonWorkerGroup() {
        WorkerGroupDao workerGroupDao = new WorkerGroupDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try (Connection connection = this.dataSource.getConnection();){
            Map<Integer, String> oldWorkerGroupMap = workerGroupDao.queryAllOldWorkerGroup(connection);
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(connection);
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
                ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
                for (int i = 0; i < tasks.size(); ++i) {
                    ObjectNode task = (ObjectNode)tasks.path(i);
                    ObjectNode workerGroupNode = (ObjectNode)task.path("workerGroupId");
                    int workerGroupId = -1;
                    if (workerGroupNode != null && workerGroupNode.canConvertToInt()) {
                        workerGroupId = workerGroupNode.asInt(-1);
                    }
                    if (workerGroupId == -1) {
                        task.put("workerGroup", "default");
                        continue;
                    }
                    task.put("workerGroup", oldWorkerGroupMap.get(workerGroupId));
                }
                jsonObject.remove("task");
                jsonObject.put("tasks", (JsonNode)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(connection, replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            log.error("update process definition json workergroup error", (Throwable)e);
        }
    }

    @Override
    public DolphinSchedulerVersion getCurrentVersion() {
        return DolphinSchedulerVersion.V1_3_0;
    }
}

