/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.upgrader.v132;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.tools.datasource.dao.ProcessDefinitionDao;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerUpgrader;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class V132DolphinSchedulerUpgrader
implements DolphinSchedulerUpgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V132DolphinSchedulerUpgrader.class);
    @Autowired
    private DataSource dataSource;

    @Override
    public void doUpgrade() {
        this.updateProcessDefinitionJsonResourceList();
    }

    private void updateProcessDefinitionJsonResourceList() {
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        HashMap<Integer, String> replaceProcessDefinitionMap = new HashMap<Integer, String>();
        try (Connection connection = this.dataSource.getConnection();){
            Map<String, Integer> resourcesMap = this.listAllResources(connection);
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(connection);
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
                ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
                for (int i = 0; i < tasks.size(); ++i) {
                    ObjectNode task = (ObjectNode)tasks.get(i);
                    ObjectNode param = (ObjectNode)task.get("params");
                    if (param != null) {
                        List resourceList = JSONUtils.toList((String)param.get("resourceList").toString(), ResourceInfo.class);
                        ResourceInfo mainJar = (ResourceInfo)JSONUtils.parseObject((String)param.get("mainJar").toString(), ResourceInfo.class);
                        if (mainJar != null && mainJar.getId() == null) {
                            String fullName;
                            String string = fullName = mainJar.getRes().startsWith("/") ? mainJar.getRes() : String.format("/%s", mainJar.getRes());
                            if (resourcesMap.containsKey(fullName)) {
                                mainJar.setId(resourcesMap.get(fullName));
                                param.put("mainJar", (JsonNode)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)mainJar)));
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)resourceList)) {
                            List newResourceList = resourceList.stream().map(resInfo -> {
                                String fullName;
                                String string = fullName = resInfo.getRes().startsWith("/") ? resInfo.getRes() : String.format("/%s", resInfo.getRes());
                                if (resInfo.getId() == null && resourcesMap.containsKey(fullName)) {
                                    resInfo.setId((Integer)resourcesMap.get(fullName));
                                }
                                return resInfo;
                            }).collect(Collectors.toList());
                            param.put("resourceList", (JsonNode)JSONUtils.parseObject((String)JSONUtils.toJsonString(newResourceList)));
                        }
                    }
                    task.put("params", (JsonNode)param);
                }
                jsonObject.remove("tasks");
                jsonObject.put("tasks", (JsonNode)tasks);
                replaceProcessDefinitionMap.put(entry.getKey(), jsonObject.toString());
            }
            if (replaceProcessDefinitionMap.size() > 0) {
                processDefinitionDao.updateProcessDefinitionJson(connection, replaceProcessDefinitionMap);
            }
        }
        catch (Exception e) {
            log.error("update process definition json resource list error", (Throwable)e);
        }
    }

    private Map<String, Integer> listAllResources(Connection conn) {
        HashMap<String, Integer> resourceMap = new HashMap<String, Integer>();
        String sql = "SELECT id,full_name FROM t_ds_resources";
        try (PreparedStatement pstmt = conn.prepareStatement(sql);
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String fullName = rs.getString(2);
                resourceMap.put(fullName, id);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
        return resourceMap;
    }

    @Override
    public DolphinSchedulerVersion getCurrentVersion() {
        return DolphinSchedulerVersion.V1_3_2;
    }
}

