/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.upgrader.v200;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;
import org.apache.dolphinscheduler.tools.datasource.dao.JsonSplitDao;
import org.apache.dolphinscheduler.tools.datasource.dao.ProcessDefinitionDao;
import org.apache.dolphinscheduler.tools.datasource.dao.ProjectDao;
import org.apache.dolphinscheduler.tools.datasource.dao.ScheduleDao;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerUpgrader;
import org.apache.dolphinscheduler.tools.datasource.upgrader.DolphinSchedulerVersion;
import org.apache.dolphinscheduler.tools.datasource.upgrader.UpgradeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class V200DolphinSchedulerUpgrader
implements DolphinSchedulerUpgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V200DolphinSchedulerUpgrader.class);
    @Autowired
    private DataSource dataSource;
    @Lazy
    @Autowired
    private UpgradeDao upgradeDao;

    @Override
    public void doUpgrade() {
        this.processDefinitionJsonSplit();
        this.upgradeDao.upgradeDolphinSchedulerDDL("2.0.0_schema", "dolphinscheduler_ddl_post.sql");
    }

    private void processDefinitionJsonSplit() {
        ProjectDao projectDao = new ProjectDao();
        ProcessDefinitionDao processDefinitionDao = new ProcessDefinitionDao();
        ScheduleDao scheduleDao = new ScheduleDao();
        JsonSplitDao jsonSplitDao = new JsonSplitDao();
        try (Connection connection = this.dataSource.getConnection();){
            Map<Integer, Long> projectIdCodeMap = projectDao.queryAllProject(connection);
            projectDao.updateProjectCode(connection, projectIdCodeMap);
            List<ProcessDefinition> processDefinitions = processDefinitionDao.queryProcessDefinition(connection);
            processDefinitionDao.updateProcessDefinitionCode(connection, processDefinitions, projectIdCodeMap);
            Map<Integer, Long> allSchedule = scheduleDao.queryAllSchedule(connection);
            Map<Integer, Long> processIdCodeMap = processDefinitions.stream().collect(Collectors.toMap(ProcessDefinition::getId, ProcessDefinition::getCode));
            scheduleDao.updateScheduleCode(connection, allSchedule, processIdCodeMap);
            Map<Integer, String> processDefinitionJsonMap = processDefinitionDao.queryAllProcessDefinition(connection);
            ArrayList<ProcessDefinitionLog> processDefinitionLogs = new ArrayList<ProcessDefinitionLog>();
            ArrayList<ProcessTaskRelationLog> processTaskRelationLogs = new ArrayList<ProcessTaskRelationLog>();
            ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
            HashMap<Integer, Map<Long, Map<String, Long>>> processTaskMap = new HashMap<Integer, Map<Long, Map<String, Long>>>();
            this.splitProcessDefinitionJson(processDefinitions, processDefinitionJsonMap, processDefinitionLogs, processTaskRelationLogs, taskDefinitionLogs, processTaskMap);
            this.convertDependence(taskDefinitionLogs, projectIdCodeMap, processTaskMap);
            jsonSplitDao.executeJsonSplitProcessDefinition(connection, processDefinitionLogs);
            jsonSplitDao.executeJsonSplitProcessTaskRelation(connection, processTaskRelationLogs);
            jsonSplitDao.executeJsonSplitTaskDefinition(connection, taskDefinitionLogs);
        }
        catch (Exception e) {
            log.error("json split error", (Throwable)e);
        }
    }

    private void splitProcessDefinitionJson(List<ProcessDefinition> processDefinitions, Map<Integer, String> processDefinitionJsonMap, List<ProcessDefinitionLog> processDefinitionLogs, List<ProcessTaskRelationLog> processTaskRelationLogs, List<TaskDefinitionLog> taskDefinitionLogs, Map<Integer, Map<Long, Map<String, Long>>> processTaskMap) throws Exception {
        Map<Integer, ProcessDefinition> processDefinitionMap = processDefinitions.stream().collect(Collectors.toMap(ProcessDefinition::getId, processDefinition -> processDefinition));
        Date now = new Date();
        for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
            if (entry.getValue() == null) {
                throw new Exception("processDefinitionJson is null");
            }
            ObjectNode jsonObject = JSONUtils.parseObject((String)entry.getValue());
            ProcessDefinition processDefinition2 = processDefinitionMap.get(entry.getKey());
            if (processDefinition2 == null) {
                throw new Exception("It can't find processDefinition, please check !");
            }
            processDefinition2.setTimeout(jsonObject.get("timeout").asInt());
            processDefinition2.setGlobalParams(jsonObject.get("globalParams").toString());
            HashMap<String, Long> taskIdCodeMap = new HashMap<String, Long>();
            HashMap<String, List<String>> taskNamePreMap = new HashMap<String, List<String>>();
            HashMap<String, Long> taskNameCodeMap = new HashMap<String, Long>();
            HashMap<Long, HashMap<String, Long>> processCodeTaskNameCodeMap = new HashMap<Long, HashMap<String, Long>>();
            ArrayList<TaskDefinitionLog> taskDefinitionLogList = new ArrayList<TaskDefinitionLog>();
            ArrayNode tasks = JSONUtils.parseArray((String)jsonObject.get("tasks").toString());
            for (int i = 0; i < tasks.size(); ++i) {
                TaskTimeoutParameter timeout;
                ObjectNode task = (ObjectNode)tasks.path(i);
                ObjectNode param = (ObjectNode)task.get("params");
                TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
                String taskType = task.get("type").asText();
                if (param != null) {
                    JsonNode jsonNodeDefinitionId;
                    JsonNode resourceJsonNode = param.get("resourceList");
                    if (resourceJsonNode != null && !resourceJsonNode.isEmpty()) {
                        List resourceList = JSONUtils.toList((String)param.get("resourceList").toString(), ResourceInfo.class);
                        List resourceIds = resourceList.stream().map(ResourceInfo::getId).collect(Collectors.toList());
                        taskDefinitionLog.setResourceIds(Joiner.on((String)",").join(resourceIds));
                    } else {
                        taskDefinitionLog.setResourceIds("");
                    }
                    if ("SUB_PROCESS".equals(taskType) && (jsonNodeDefinitionId = param.get("processDefinitionId")) != null) {
                        param.put("processDefinitionCode", processDefinitionMap.get(jsonNodeDefinitionId.asInt()).getCode());
                        param.remove("processDefinitionId");
                    }
                    param.put("conditionResult", task.get("conditionResult"));
                    param.put("dependence", task.get("dependence"));
                    taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)param));
                }
                if ((timeout = (TaskTimeoutParameter)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)task.get("timeout")), TaskTimeoutParameter.class)) != null) {
                    taskDefinitionLog.setTimeout(timeout.getInterval());
                    taskDefinitionLog.setTimeoutFlag(timeout.getEnable() ? TimeoutFlag.OPEN : TimeoutFlag.CLOSE);
                    taskDefinitionLog.setTimeoutNotifyStrategy(timeout.getStrategy());
                }
                String desc = task.get("description") != null ? task.get("description").asText() : (task.get("desc") != null ? task.get("desc").asText() : "");
                taskDefinitionLog.setDescription(desc);
                taskDefinitionLog.setFlag("NORMAL".equals(task.get("runFlag").asText()) ? Flag.YES : Flag.NO);
                taskDefinitionLog.setTaskType(taskType);
                taskDefinitionLog.setFailRetryInterval("SUB_PROCESS".equals(taskType) ? 1 : task.get("retryInterval").asInt());
                taskDefinitionLog.setFailRetryTimes("SUB_PROCESS".equals(taskType) ? 0 : task.get("maxRetryTimes").asInt());
                taskDefinitionLog.setTaskPriority((Priority)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)task.get("taskInstancePriority")), Priority.class));
                String name = task.get("name").asText();
                taskDefinitionLog.setName(name);
                taskDefinitionLog.setWorkerGroup(task.get("workerGroup") == null ? "default" : task.get("workerGroup").asText());
                long taskCode = CodeGenerateUtils.getInstance().genCode();
                taskDefinitionLog.setCode(taskCode);
                taskDefinitionLog.setVersion(1);
                taskDefinitionLog.setProjectCode(processDefinition2.getProjectCode());
                taskDefinitionLog.setUserId(processDefinition2.getUserId());
                taskDefinitionLog.setEnvironmentCode(-1L);
                taskDefinitionLog.setDelayTime(0);
                taskDefinitionLog.setOperator(1);
                taskDefinitionLog.setOperateTime(now);
                taskDefinitionLog.setCreateTime(now);
                taskDefinitionLog.setUpdateTime(now);
                taskDefinitionLogList.add(taskDefinitionLog);
                taskIdCodeMap.put(task.get("id").asText(), taskCode);
                List preTasks = JSONUtils.toList((String)task.get("preTasks").toString(), String.class);
                taskNamePreMap.put(name, preTasks);
                taskNameCodeMap.put(name, taskCode);
            }
            this.convertConditions(taskDefinitionLogList, taskNameCodeMap);
            taskDefinitionLogs.addAll(taskDefinitionLogList);
            processDefinition2.setLocations(this.convertLocations(processDefinition2.getLocations(), taskIdCodeMap));
            ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition2);
            processDefinitionLog.setOperator(1);
            processDefinitionLog.setOperateTime(now);
            processDefinitionLog.setUpdateTime(now);
            processDefinitionLogs.add(processDefinitionLog);
            this.handleProcessTaskRelation(taskNamePreMap, taskNameCodeMap, processDefinition2, processTaskRelationLogs);
            processCodeTaskNameCodeMap.put(processDefinition2.getCode(), taskNameCodeMap);
            processTaskMap.put(entry.getKey(), processCodeTaskNameCodeMap);
        }
    }

    private void convertDependence(List<TaskDefinitionLog> taskDefinitionLogs, Map<Integer, Long> projectIdCodeMap, Map<Integer, Map<Long, Map<String, Long>>> processTaskMap) {
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (!"DEPENDENT".equals(taskDefinitionLog.getTaskType())) continue;
            ObjectNode taskParams = JSONUtils.parseObject((String)taskDefinitionLog.getTaskParams());
            ObjectNode dependence = (ObjectNode)taskParams.get("dependence");
            ArrayNode dependTaskList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependence.get("dependTaskList")));
            for (int i = 0; i < dependTaskList.size(); ++i) {
                ObjectNode dependTask = (ObjectNode)dependTaskList.path(i);
                ArrayNode dependItemList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependTask.get("dependItemList")));
                for (int j = 0; j < dependItemList.size(); ++j) {
                    ObjectNode dependItem = (ObjectNode)dependItemList.path(j);
                    dependItem.put("projectCode", projectIdCodeMap.get(dependItem.get("projectId").asInt()));
                    int definitionId = dependItem.get("definitionId").asInt();
                    Map<Long, Map<String, Long>> processCodeTaskNameCodeMap = processTaskMap.get(definitionId);
                    if (processCodeTaskNameCodeMap == null) {
                        log.warn("We can't find processDefinition [{}], please check it is not exist, remove this dependence", (Object)definitionId);
                        dependItemList.remove(j);
                        continue;
                    }
                    Optional mapEntry = processCodeTaskNameCodeMap.entrySet().stream().findFirst();
                    if (mapEntry.isPresent()) {
                        Map.Entry processCodeTaskNameCodeEntry = (Map.Entry)mapEntry.get();
                        dependItem.put("definitionCode", (Long)processCodeTaskNameCodeEntry.getKey());
                        String depTasks = dependItem.get("depTasks").asText();
                        long taskCode = "ALL".equals(depTasks) || processCodeTaskNameCodeEntry.getValue() == null ? 0L : (Long)((Map)processCodeTaskNameCodeEntry.getValue()).get(depTasks);
                        dependItem.put("depTaskCode", taskCode);
                    }
                    dependItem.remove("projectId");
                    dependItem.remove("definitionId");
                    dependItem.remove("depTasks");
                    dependItemList.set(j, (JsonNode)dependItem);
                }
                dependTask.put("dependItemList", (JsonNode)dependItemList);
                dependTaskList.set(i, (JsonNode)dependTask);
            }
            dependence.put("dependTaskList", (JsonNode)dependTaskList);
            taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
        }
    }

    private void convertConditions(List<TaskDefinitionLog> taskDefinitionLogList, Map<String, Long> taskNameCodeMap) throws Exception {
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogList) {
            if (!"CONDITIONS".equals(taskDefinitionLog.getTaskType())) continue;
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode taskParams = JSONUtils.parseObject((String)taskDefinitionLog.getTaskParams());
            ObjectNode conditionResult = (ObjectNode)taskParams.get("conditionResult");
            List successNode = JSONUtils.toList((String)conditionResult.get("successNode").toString(), String.class);
            ArrayList nodeCode = new ArrayList();
            successNode.forEach(node -> nodeCode.add(taskNameCodeMap.get(node)));
            conditionResult.set("successNode", objectMapper.readTree(objectMapper.writeValueAsString(nodeCode)));
            List failedNode = JSONUtils.toList((String)conditionResult.get("failedNode").toString(), String.class);
            nodeCode.clear();
            failedNode.forEach(node -> nodeCode.add(taskNameCodeMap.get(node)));
            conditionResult.set("failedNode", objectMapper.readTree(objectMapper.writeValueAsString(nodeCode)));
            ObjectNode dependence = (ObjectNode)taskParams.get("dependence");
            ArrayNode dependTaskList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependence.get("dependTaskList")));
            for (int i = 0; i < dependTaskList.size(); ++i) {
                ObjectNode dependTask = (ObjectNode)dependTaskList.path(i);
                ArrayNode dependItemList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependTask.get("dependItemList")));
                for (int j = 0; j < dependItemList.size(); ++j) {
                    ObjectNode dependItem = (ObjectNode)dependItemList.path(j);
                    JsonNode depTasks = dependItem.get("depTasks");
                    dependItem.put("depTaskCode", taskNameCodeMap.get(depTasks.asText()));
                    dependItem.remove("depTasks");
                    dependItemList.set(j, (JsonNode)dependItem);
                }
                dependTask.put("dependItemList", (JsonNode)dependItemList);
                dependTaskList.set(i, (JsonNode)dependTask);
            }
            dependence.put("dependTaskList", (JsonNode)dependTaskList);
            taskDefinitionLog.setTaskParams(JSONUtils.toJsonString((Object)taskParams));
        }
    }

    private String convertLocations(String locations, Map<String, Long> taskIdCodeMap) {
        if (Strings.isNullOrEmpty((String)locations)) {
            return locations;
        }
        Map locationsMap = (Map)JSONUtils.parseObject((String)locations, (TypeReference)new TypeReference<Map<String, ObjectNode>>(){});
        if (locationsMap == null) {
            return locations;
        }
        ArrayNode jsonNodes = JSONUtils.createArrayNode();
        for (Map.Entry entry : locationsMap.entrySet()) {
            ObjectNode nodes = JSONUtils.createObjectNode();
            nodes.put("taskCode", taskIdCodeMap.get(entry.getKey()));
            ObjectNode oldNodes = (ObjectNode)entry.getValue();
            nodes.put("x", oldNodes.get("x").asInt());
            nodes.put("y", oldNodes.get("y").asInt());
            jsonNodes.add((JsonNode)nodes);
        }
        return jsonNodes.toString();
    }

    private void handleProcessTaskRelation(Map<String, List<String>> taskNamePreMap, Map<String, Long> taskNameCodeMap, ProcessDefinition processDefinition, List<ProcessTaskRelationLog> processTaskRelationLogs) {
        Date now = new Date();
        for (Map.Entry<String, List<String>> entry : taskNamePreMap.entrySet()) {
            List<String> entryValue = entry.getValue();
            if (CollectionUtils.isNotEmpty(entryValue)) {
                for (String preTaskName : entryValue) {
                    ProcessTaskRelationLog processTaskRelationLog = this.setProcessTaskRelationLog(processDefinition, now);
                    processTaskRelationLog.setPreTaskCode(taskNameCodeMap.get(preTaskName).longValue());
                    processTaskRelationLog.setPreTaskVersion(1);
                    processTaskRelationLog.setPostTaskCode(taskNameCodeMap.get(entry.getKey()).longValue());
                    processTaskRelationLog.setPostTaskVersion(1);
                    processTaskRelationLogs.add(processTaskRelationLog);
                }
                continue;
            }
            ProcessTaskRelationLog processTaskRelationLog = this.setProcessTaskRelationLog(processDefinition, now);
            processTaskRelationLog.setPreTaskCode(0L);
            processTaskRelationLog.setPreTaskVersion(0);
            processTaskRelationLog.setPostTaskCode(taskNameCodeMap.get(entry.getKey()).longValue());
            processTaskRelationLog.setPostTaskVersion(1);
            processTaskRelationLogs.add(processTaskRelationLog);
        }
    }

    private ProcessTaskRelationLog setProcessTaskRelationLog(ProcessDefinition processDefinition, Date now) {
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
        processTaskRelationLog.setProjectCode(processDefinition.getProjectCode());
        processTaskRelationLog.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelationLog.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelationLog.setConditionType(ConditionType.NONE);
        processTaskRelationLog.setConditionParams("{}");
        processTaskRelationLog.setOperator(1);
        processTaskRelationLog.setOperateTime(now);
        processTaskRelationLog.setCreateTime(now);
        processTaskRelationLog.setUpdateTime(now);
        return processTaskRelationLog;
    }

    @Override
    public DolphinSchedulerVersion getCurrentVersion() {
        return DolphinSchedulerVersion.V2_0_0;
    }
}

