/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.remote.command.BaseCommand;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.server.worker.message.MessageSender;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MessageRetryRunner
extends BaseDaemonThread {
    private final Logger logger = LoggerFactory.getLogger(MessageRetryRunner.class);
    private static long MESSAGE_RETRY_WINDOW = Duration.ofMinutes(5L).toMillis();
    @Lazy
    @Autowired
    private List<MessageSender> messageSenders;
    private Map<CommandType, MessageSender<BaseCommand>> messageSenderMap = new HashMap<CommandType, MessageSender<BaseCommand>>();
    private Map<Integer, Map<CommandType, BaseCommand>> needToRetryMessages = new ConcurrentHashMap<Integer, Map<CommandType, BaseCommand>>();

    protected MessageRetryRunner() {
        super("WorkerMessageRetryRunnerThread");
    }

    public synchronized void start() {
        this.logger.info("Message retry runner staring");
        this.messageSenders.forEach(messageSender -> {
            this.messageSenderMap.put(messageSender.getMessageType(), (MessageSender<BaseCommand>)messageSender);
            this.logger.info("Injected message sender: {}", (Object)messageSender.getClass().getName());
        });
        super.start();
        this.logger.info("Message retry runner started");
    }

    public void addRetryMessage(int taskInstanceId, @NonNull CommandType messageType, BaseCommand baseCommand) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.needToRetryMessages.computeIfAbsent(taskInstanceId, k -> new ConcurrentHashMap()).put(messageType, baseCommand);
    }

    public void removeRetryMessage(int taskInstanceId, @NonNull CommandType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        Map<CommandType, BaseCommand> retryMessages = this.needToRetryMessages.get(taskInstanceId);
        if (retryMessages != null) {
            retryMessages.remove(messageType);
        }
    }

    public void removeRetryMessages(int taskInstanceId) {
        this.needToRetryMessages.remove(taskInstanceId);
    }

    public void updateMessageHost(int taskInstanceId, String messageReceiverHost) {
        Map<CommandType, BaseCommand> needToRetryMessages = this.needToRetryMessages.get(taskInstanceId);
        if (needToRetryMessages != null) {
            needToRetryMessages.values().forEach(baseMessage -> baseMessage.setMessageReceiverAddress(messageReceiverHost));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                if (MapUtils.isEmpty(this.needToRetryMessages)) {
                    Thread.sleep(MESSAGE_RETRY_WINDOW);
                }
                long now = System.currentTimeMillis();
                for (Map.Entry<Integer, Map<CommandType, BaseCommand>> taskEntry : this.needToRetryMessages.entrySet()) {
                    Integer taskInstanceId = taskEntry.getKey();
                    LoggerUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
                    try {
                        for (Map.Entry<CommandType, BaseCommand> messageEntry : taskEntry.getValue().entrySet()) {
                            CommandType messageType = messageEntry.getKey();
                            BaseCommand message = messageEntry.getValue();
                            if (now - message.getMessageSendTime() <= MESSAGE_RETRY_WINDOW) continue;
                            this.logger.info("Begin retry send message to master, message: {}", (Object)message);
                            message.setMessageSendTime(now);
                            this.messageSenderMap.get(messageType).sendMessage(message);
                            this.logger.info("Success send message to master, message: {}", (Object)message);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("Retry send message to master error", (Throwable)e);
                    }
                    finally {
                        LoggerUtils.removeTaskInstanceIdMDC();
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException instance) {
                this.logger.warn("The message retry thread is interrupted, will break this loop", (Throwable)instance);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                this.logger.error("Retry send message failed, get an known exception.", (Throwable)ex);
            }
        }
    }

    public void clearMessage() {
        this.needToRetryMessages.clear();
    }
}

