/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResultCommand;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageSender;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteResultMessageSender
implements MessageSender<TaskExecuteResultCommand> {
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private WorkerRpcClient workerRpcClient;

    @Override
    public void sendMessage(TaskExecuteResultCommand message) throws RemotingException {
        this.workerRpcClient.send(Host.of((String)message.getMessageReceiverAddress()), message.convert2Command());
    }

    @Override
    public TaskExecuteResultCommand buildMessage(TaskExecutionContext taskExecutionContext, String messageReceiverAddress) {
        TaskExecuteResultCommand taskExecuteResultMessage = new TaskExecuteResultCommand(this.workerConfig.getWorkerAddress(), messageReceiverAddress, System.currentTimeMillis());
        taskExecuteResultMessage.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskExecuteResultMessage.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskExecuteResultMessage.setStatus(taskExecutionContext.getCurrentExecutionStatus().getCode());
        taskExecuteResultMessage.setLogPath(taskExecutionContext.getLogPath());
        taskExecuteResultMessage.setExecutePath(taskExecutionContext.getExecutePath());
        taskExecuteResultMessage.setAppIds(taskExecutionContext.getAppIds());
        taskExecuteResultMessage.setProcessId(taskExecutionContext.getProcessId());
        taskExecuteResultMessage.setHost(taskExecutionContext.getHost());
        taskExecuteResultMessage.setStartTime(taskExecutionContext.getStartTime());
        taskExecuteResultMessage.setEndTime(taskExecutionContext.getEndTime());
        taskExecuteResultMessage.setVarPool(taskExecutionContext.getVarPool());
        taskExecuteResultMessage.setExecutePath(taskExecutionContext.getExecutePath());
        return taskExecuteResultMessage;
    }

    @Override
    public CommandType getMessageType() {
        return CommandType.TASK_EXECUTE_RESULT;
    }
}

