/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskRejectCommand;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageSender;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskRejectMessageSender
implements MessageSender<TaskRejectCommand> {
    @Autowired
    private WorkerRpcClient workerRpcClient;
    @Autowired
    private WorkerConfig workerConfig;

    @Override
    public void sendMessage(TaskRejectCommand message) throws RemotingException {
        this.workerRpcClient.send(Host.of((String)message.getMessageReceiverAddress()), message.convert2Command());
    }

    @Override
    public TaskRejectCommand buildMessage(TaskExecutionContext taskExecutionContext, String masterAddress) {
        TaskRejectCommand taskRejectMessage = new TaskRejectCommand(this.workerConfig.getWorkerAddress(), masterAddress, System.currentTimeMillis());
        taskRejectMessage.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskRejectMessage.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskRejectMessage.setHost(taskExecutionContext.getHost());
        return taskRejectMessage;
    }

    @Override
    public CommandType getMessageType() {
        return CommandType.TASK_REJECT;
    }
}

