/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteRunningAckMessage;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteRunningAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteRunningAckProcessor.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RUNNING_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteRunningAckMessage runningAckCommand = (TaskExecuteRunningAckMessage)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteRunningAckMessage.class);
        if (runningAckCommand == null) {
            this.logger.error("task execute running ack command is null");
            return;
        }
        try {
            LoggerUtils.setTaskInstanceIdMDC((Integer)runningAckCommand.getTaskInstanceId());
            this.logger.info("task execute running ack command : {}", (Object)runningAckCommand);
            if (runningAckCommand.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(runningAckCommand.getTaskInstanceId(), CommandType.TASK_EXECUTE_RUNNING);
            }
        }
        finally {
            LoggerUtils.removeTaskInstanceIdMDC();
        }
    }
}

