/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.micrometer.core.lang.NonNull;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.command.TaskKillResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.Pair;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecuteRunnable;
import org.apache.dolphinscheduler.service.log.LogClient;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.apache.dolphinscheduler.service.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskKillProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskKillProcessor.class);
    @Autowired
    private WorkerManagerThread workerManager;
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private LogClient logClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_KILL_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskKillRequestCommand killCommand = (TaskKillRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskKillRequestCommand.class);
        if (killCommand == null) {
            this.logger.error("task kill request command is null");
            return;
        }
        this.logger.info("task kill command : {}", (Object)killCommand);
        int taskInstanceId = killCommand.getTaskInstanceId();
        try {
            LoggerUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            TaskExecutionContext taskExecutionContext = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
            if (taskExecutionContext == null) {
                this.logger.error("taskRequest cache is null, taskInstanceId: {}", (Object)killCommand.getTaskInstanceId());
                return;
            }
            int processId = taskExecutionContext.getProcessId();
            if (processId == 0) {
                this.cancelApplication(taskInstanceId);
                this.workerManager.killTaskBeforeExecuteByInstanceId(taskInstanceId);
                taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.KILL);
                TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskInstanceId);
                this.sendTaskKillResponseCommand(channel, taskExecutionContext);
                this.logger.info("the task has not been executed and has been cancelled, task id:{}", (Object)taskInstanceId);
                return;
            }
            this.cancelApplication(taskInstanceId);
            Pair<Boolean, List<String>> result = this.doKill(taskExecutionContext);
            taskExecutionContext.setCurrentExecutionStatus((Boolean)result.getLeft() != false ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE);
            taskExecutionContext.setAppIds(String.join((CharSequence)",", (Iterable)result.getRight()));
            this.sendTaskKillResponseCommand(channel, taskExecutionContext);
            TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskExecutionContext.getTaskInstanceId());
            this.messageRetryRunner.removeRetryMessages(taskExecutionContext.getTaskInstanceId());
            this.logger.info("remove REMOTE_CHANNELS, task instance id:{}", (Object)killCommand.getTaskInstanceId());
        }
        finally {
            LoggerUtils.removeTaskInstanceIdMDC();
        }
    }

    private void sendTaskKillResponseCommand(Channel channel, TaskExecutionContext taskExecutionContext) {
        final TaskKillResponseCommand taskKillResponseCommand = new TaskKillResponseCommand();
        taskKillResponseCommand.setStatus(taskExecutionContext.getCurrentExecutionStatus());
        if (taskExecutionContext.getAppIds() != null) {
            taskKillResponseCommand.setAppIds(Arrays.asList(taskExecutionContext.getAppIds().split(",")));
        }
        taskKillResponseCommand.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskKillResponseCommand.setHost(taskExecutionContext.getHost());
        taskKillResponseCommand.setProcessId(taskExecutionContext.getProcessId());
        channel.writeAndFlush((Object)taskKillResponseCommand.convert2Command()).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    TaskKillProcessor.this.logger.error("Submit kill response to master error, kill command: {}", (Object)taskKillResponseCommand);
                }
            }
        });
    }

    private Pair<Boolean, List<String>> doKill(TaskExecutionContext taskExecutionContext) {
        boolean processFlag = this.killProcess(taskExecutionContext.getTenantCode(), taskExecutionContext.getProcessId());
        Pair<Boolean, List<String>> yarnResult = this.killYarnJob(Host.of((String)taskExecutionContext.getHost()), taskExecutionContext.getLogPath(), taskExecutionContext.getExecutePath(), taskExecutionContext.getTenantCode());
        return Pair.of((Object)(processFlag && (Boolean)yarnResult.getLeft() != false ? 1 : 0), (Object)yarnResult.getRight());
    }

    protected void cancelApplication(int taskInstanceId) {
        WorkerTaskExecuteRunnable workerTaskExecuteRunnable = this.workerManager.getTaskExecuteThread(taskInstanceId);
        if (workerTaskExecuteRunnable == null) {
            this.logger.warn("taskExecuteThread not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        AbstractTask task = workerTaskExecuteRunnable.getTask();
        if (task == null) {
            this.logger.warn("task not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        try {
            task.cancel();
        }
        catch (Exception e) {
            this.logger.error("kill task error", (Throwable)e);
        }
        this.logger.info("kill task by cancelApplication, task id:{}", (Object)taskInstanceId);
    }

    protected boolean killProcess(String tenantCode, Integer processId) {
        boolean processFlag = true;
        if (processId == null || processId.equals(0)) {
            return true;
        }
        try {
            String pidsStr = ProcessUtils.getPidsStr((int)processId);
            if (!Strings.isNullOrEmpty((String)pidsStr)) {
                String cmd = String.format("kill -9 %s", pidsStr);
                cmd = OSUtils.getSudoCmd((String)tenantCode, (String)cmd);
                this.logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
                OSUtils.exeCmd((String)cmd);
            }
        }
        catch (Exception e) {
            processFlag = false;
            this.logger.error("kill task error", (Throwable)e);
        }
        return processFlag;
    }

    private Pair<Boolean, List<String>> killYarnJob(@NonNull Host host, String logPath, String executePath, String tenantCode) {
        if (logPath == null || executePath == null || tenantCode == null) {
            this.logger.error("Kill yarn job error, the input params is illegal, host: {}, logPath: {}, executePath: {}, tenantCode: {}", new Object[]{host, logPath, executePath, tenantCode});
            return Pair.of((Object)false, Collections.emptyList());
        }
        try {
            this.logger.info("Get appIds from worker {}:{} taskLogPath: {}", new Object[]{host.getIp(), host.getPort(), logPath});
            List appIds = this.logClient.getAppIds(host.getIp(), host.getPort(), logPath);
            if (CollectionUtils.isEmpty((Collection)appIds)) {
                this.logger.info("The appId is empty");
                return Pair.of((Object)true, Collections.emptyList());
            }
            ProcessUtils.cancelApplication((List)appIds, (Logger)this.logger, (String)tenantCode, (String)executePath);
            return Pair.of((Object)true, (Object)appIds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("kill yarn job error, the current thread has been interrtpted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Kill yarn job error, host: {}, logPath: {}, executePath: {}, tenantCode: {}", new Object[]{host, logPath, executePath, tenantCode, e});
        }
        return Pair.of((Object)false, Collections.emptyList());
    }
}

