/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.stream.StreamTask;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskSavePointRequestCommand;
import org.apache.dolphinscheduler.remote.command.TaskSavePointResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecuteRunnable;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskSavePointProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskSavePointProcessor.class);
    @Autowired
    private WorkerManagerThread workerManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_SAVEPOINT_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskSavePointRequestCommand taskSavePointRequestCommand = (TaskSavePointRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskSavePointRequestCommand.class);
        if (taskSavePointRequestCommand == null) {
            this.logger.error("task savepoint request command is null");
            return;
        }
        this.logger.info("Receive task savepoint command : {}", (Object)taskSavePointRequestCommand);
        int taskInstanceId = taskSavePointRequestCommand.getTaskInstanceId();
        TaskExecutionContext taskExecutionContext = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
        if (taskExecutionContext == null) {
            this.logger.error("taskRequest cache is null, taskInstanceId: {}", (Object)taskSavePointRequestCommand.getTaskInstanceId());
            return;
        }
        try {
            LoggerUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            this.doSavePoint(taskInstanceId);
            this.sendTaskSavePointResponseCommand(channel, taskExecutionContext);
        }
        finally {
            LoggerUtils.removeTaskInstanceIdMDC();
        }
    }

    private void sendTaskSavePointResponseCommand(Channel channel, TaskExecutionContext taskExecutionContext) {
        final TaskSavePointResponseCommand taskSavePointResponseCommand = new TaskSavePointResponseCommand();
        taskSavePointResponseCommand.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        channel.writeAndFlush((Object)taskSavePointResponseCommand.convert2Command()).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    TaskSavePointProcessor.this.logger.error("Submit kill response to master error, kill command: {}", (Object)taskSavePointResponseCommand);
                } else {
                    TaskSavePointProcessor.this.logger.info("Submit kill response to master success, kill command: {}", (Object)taskSavePointResponseCommand);
                }
            }
        });
    }

    protected void doSavePoint(int taskInstanceId) {
        WorkerTaskExecuteRunnable workerTaskExecuteRunnable = this.workerManager.getTaskExecuteThread(taskInstanceId);
        if (workerTaskExecuteRunnable == null) {
            this.logger.warn("taskExecuteThread not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        AbstractTask task = workerTaskExecuteRunnable.getTask();
        if (task == null) {
            this.logger.warn("task not found, taskInstanceId:{}", (Object)taskInstanceId);
            return;
        }
        if (!(task instanceof StreamTask)) {
            this.logger.warn("task is not stream task");
            return;
        }
        try {
            ((StreamTask)task).savePoint();
        }
        catch (Exception e) {
            this.logger.error("task save point error", (Throwable)e);
        }
    }
}

