/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectStrategy;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="worker.registry-disconnect-strategy", name={"strategy"}, havingValue="stop", matchIfMissing=true)
public class WorkerStopStrategy
implements WorkerConnectStrategy {
    private final Logger logger = LoggerFactory.getLogger(WorkerStopStrategy.class);
    @Autowired
    public RegistryClient registryClient;
    @Autowired
    private WorkerConfig workerConfig;

    public void disconnect() {
        this.registryClient.getStoppable().stop("Worker disconnected from registry, will stop myself due to the stop strategy");
    }

    public void reconnect() {
        this.logger.warn("The current connect strategy is stop, so the worker will not reconnect to registry");
    }

    public StrategyType getStrategyType() {
        return StrategyType.STOP;
    }
}

