/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import java.time.Duration;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectStrategy;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcClient;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcServer;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="worker.registry-disconnect-strategy", name={"strategy"}, havingValue="waiting")
public class WorkerWaitingStrategy
implements WorkerConnectStrategy {
    private final Logger logger = LoggerFactory.getLogger(WorkerWaitingStrategy.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private WorkerRpcServer workerRpcServer;
    @Autowired
    private WorkerRpcClient workerRpcClient;
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private WorkerManagerThread workerManagerThread;

    public void disconnect() {
        try {
            ServerLifeCycleManager.toWaiting();
            this.clearWorkerResource();
            Duration maxWaitingTime = this.workerConfig.getRegistryDisconnectStrategy().getMaxWaitingTime();
            try {
                this.logger.info("Worker disconnect from registry will try to reconnect in {} s", (Object)maxWaitingTime.getSeconds());
                this.registryClient.connectUntilTimeout(maxWaitingTime);
            }
            catch (RegistryException ex) {
                throw new ServerLifeCycleException(String.format("Waiting to reconnect to registry in %s failed", maxWaitingTime), (Throwable)ex);
            }
        }
        catch (ServerLifeCycleException e) {
            String errorMessage = String.format("Disconnect from registry and change the current status to waiting error, the current server state is %s, will stop the current server", ServerLifeCycleManager.getServerStatus());
            this.logger.error(errorMessage, (Throwable)e);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (RegistryException ex) {
            String errorMessage = "Disconnect from registry and waiting to reconnect failed, will stop the server";
            this.logger.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (Exception ex) {
            String errorMessage = "Disconnect from registry and get an unknown exception, will stop the server";
            this.logger.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
    }

    public void reconnect() {
        if (ServerLifeCycleManager.isRunning()) {
            this.logger.info("no need to reconnect, as the current server status is running");
        } else {
            try {
                ServerLifeCycleManager.recoverFromWaiting();
                this.reStartWorkerResource();
                this.logger.info("Recover from waiting success, the current server status is {}", (Object)ServerLifeCycleManager.getServerStatus());
            }
            catch (Exception e) {
                String errorMessage = String.format("Recover from waiting failed, the current server status is %s, will stop the server", ServerLifeCycleManager.getServerStatus());
                this.logger.error(errorMessage, (Throwable)e);
                this.registryClient.getStoppable().stop(errorMessage);
            }
        }
    }

    public StrategyType getStrategyType() {
        return StrategyType.WAITING;
    }

    private void clearWorkerResource() {
        this.workerRpcServer.close();
        this.logger.warn("Worker server close the RPC server due to lost connection from registry");
        this.workerRpcClient.close();
        this.logger.warn("Worker server close the RPC client due to lost connection from registry");
        this.workerManagerThread.clearTask();
        this.logger.warn("Worker server clear the tasks due to lost connection from registry");
        this.messageRetryRunner.clearMessage();
        this.logger.warn("Worker server clear the retry message due to lost connection from registry");
    }

    private void reStartWorkerResource() {
        this.workerRpcServer.start();
        this.logger.warn("Worker server restart PRC server due to reconnect to registry");
        this.workerRpcClient.start();
        this.logger.warn("Worker server restart PRC client due to reconnect to registry");
    }
}

