/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import java.io.Closeable;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.processor.HostUpdateProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskDispatchProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteResultAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskExecuteRunningAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskKillProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskRejectAckProcessor;
import org.apache.dolphinscheduler.server.worker.processor.TaskSavePointProcessor;
import org.apache.dolphinscheduler.service.log.LoggerRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerRpcServer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerRpcServer.class);
    @Autowired
    private TaskDispatchProcessor taskDispatchProcessor;
    @Autowired
    private TaskKillProcessor taskKillProcessor;
    @Autowired
    private TaskRejectAckProcessor taskRejectAckProcessor;
    @Autowired
    private TaskSavePointProcessor taskSavePointProcessor;
    @Autowired
    private TaskExecuteRunningAckProcessor taskExecuteRunningAckProcessor;
    @Autowired
    private TaskExecuteResultAckProcessor taskExecuteResultAckProcessor;
    @Autowired
    private HostUpdateProcessor hostUpdateProcessor;
    @Autowired
    private LoggerRequestProcessor loggerRequestProcessor;
    @Autowired
    private WorkerConfig workerConfig;
    private NettyRemotingServer nettyRemotingServer;

    public void start() {
        LOGGER.info("Worker rpc server starting");
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.workerConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_DISPATCH_REQUEST, (NettyRequestProcessor)this.taskDispatchProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_REQUEST, (NettyRequestProcessor)this.taskKillProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RUNNING_ACK, (NettyRequestProcessor)this.taskExecuteRunningAckProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESULT_ACK, (NettyRequestProcessor)this.taskExecuteResultAckProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_REJECT_ACK, (NettyRequestProcessor)this.taskRejectAckProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.PROCESS_HOST_UPDATE_REQUEST, (NettyRequestProcessor)this.hostUpdateProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_SAVEPOINT_REQUEST, (NettyRequestProcessor)this.taskSavePointProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.GET_APP_ID_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.GET_LOG_BYTES_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.ROLL_VIEW_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.VIEW_WHOLE_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.REMOVE_TAK_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.start();
        LOGGER.info("Worker rpc server started");
    }

    @Override
    public void close() {
        LOGGER.info("Worker rpc server closing");
        this.nettyRemotingServer.close();
        LOGGER.info("Worker rpc server closed");
    }
}

