/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.plugin.task.api.model.ApplicationInfo;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCallbackImpl
implements TaskCallBack {
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger-%s", TaskCallbackImpl.class));
    private final WorkerMessageSender workerMessageSender;
    private final String masterAddress;

    public TaskCallbackImpl(WorkerMessageSender workerMessageSender, String masterAddress) {
        this.workerMessageSender = workerMessageSender;
        this.masterAddress = masterAddress;
    }

    public void updateRemoteApplicationInfo(int taskInstanceId, ApplicationInfo applicationInfo) {
        TaskExecutionContext taskExecutionContext = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
        if (taskExecutionContext == null) {
            this.logger.error("task execution context is empty, taskInstanceId: {}, applicationInfo:{}", (Object)taskInstanceId, (Object)applicationInfo);
            return;
        }
        this.logger.info("send remote application info {}", (Object)applicationInfo);
        taskExecutionContext.setAppIds(applicationInfo.getAppIds());
        this.workerMessageSender.sendMessageWithRetry(taskExecutionContext, this.masterAddress, CommandType.TASK_EXECUTE_RUNNING);
    }

    @Generated
    public static TaskCallbackImplBuilder builder() {
        return new TaskCallbackImplBuilder();
    }

    @Generated
    public static class TaskCallbackImplBuilder {
        @Generated
        private WorkerMessageSender workerMessageSender;
        @Generated
        private String masterAddress;

        @Generated
        TaskCallbackImplBuilder() {
        }

        @Generated
        public TaskCallbackImplBuilder workerMessageSender(WorkerMessageSender workerMessageSender) {
            this.workerMessageSender = workerMessageSender;
            return this;
        }

        @Generated
        public TaskCallbackImplBuilder masterAddress(String masterAddress) {
            this.masterAddress = masterAddress;
            return this;
        }

        @Generated
        public TaskCallbackImpl build() {
            return new TaskCallbackImpl(this.workerMessageSender, this.masterAddress);
        }

        @Generated
        public String toString() {
            return "TaskCallbackImpl.TaskCallbackImplBuilder(workerMessageSender=" + this.workerMessageSender + ", masterAddress=" + this.masterAddress + ")";
        }
    }
}

