/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerHeartBeatTask
extends BaseHeartBeatTask<WorkerHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerHeartBeatTask.class);
    private final WorkerConfig workerConfig;
    private final RegistryClient registryClient;
    private final Supplier<Integer> workerWaitingTaskCount;
    private final int processId;

    public WorkerHeartBeatTask(@NonNull WorkerConfig workerConfig, @NonNull RegistryClient registryClient, @NonNull Supplier<Integer> workerWaitingTaskCount) {
        super("WorkerHeartBeatTask", workerConfig.getHeartbeatInterval().toMillis());
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (workerWaitingTaskCount == null) {
            throw new NullPointerException("workerWaitingTaskCount is marked non-null but is null");
        }
        this.workerConfig = workerConfig;
        this.registryClient = registryClient;
        this.workerWaitingTaskCount = workerWaitingTaskCount;
        this.processId = OSUtils.getProcessID();
    }

    public WorkerHeartBeat getHeartBeat() {
        double loadAverage = OSUtils.loadAverage();
        double cpuUsage = OSUtils.cpuUsage();
        int maxCpuLoadAvg = this.workerConfig.getMaxCpuLoadAvg();
        double reservedMemory = this.workerConfig.getReservedMemory();
        double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
        int execThreads = this.workerConfig.getExecThreads();
        int workerWaitingTaskCount = this.workerWaitingTaskCount.get();
        int serverStatus = this.getServerStatus(loadAverage, maxCpuLoadAvg, availablePhysicalMemorySize, reservedMemory, execThreads, workerWaitingTaskCount);
        return WorkerHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime()).reportTime(System.currentTimeMillis()).cpuUsage(cpuUsage).loadAverage(loadAverage).availablePhysicalMemorySize(availablePhysicalMemorySize).maxCpuloadAvg((double)maxCpuLoadAvg).memoryUsage(OSUtils.memoryUsage()).reservedMemory(reservedMemory).diskAvailable(OSUtils.diskAvailable()).processId(this.processId).workerHostWeight(this.workerConfig.getHostWeight()).workerWaitingTaskCount(this.workerWaitingTaskCount.get().intValue()).workerExecThreadCount(this.workerConfig.getExecThreads()).serverStatus(serverStatus).build();
    }

    public void writeHeartBeat(WorkerHeartBeat workerHeartBeat) {
        String workerHeartBeatJson = JSONUtils.toJsonString((Object)workerHeartBeat);
        String workerRegistryPath = this.workerConfig.getWorkerRegistryPath();
        this.registryClient.persistEphemeral(workerRegistryPath, workerHeartBeatJson);
        log.info("Success write worker group heartBeatInfo into registry, workerRegistryPath: {} workerHeartBeatInfo: {}", (Object)workerRegistryPath, (Object)workerHeartBeatJson);
    }

    public int getServerStatus(double loadAverage, double maxCpuloadAvg, double availablePhysicalMemorySize, double reservedMemory, int workerExecThreadCount, int workerWaitingTaskCount) {
        if (loadAverage > maxCpuloadAvg || availablePhysicalMemorySize < reservedMemory) {
            log.warn("current cpu load average {} is too high or available memory {}G is too low, under max.cpuload.avg={} and reserved.memory={}G", new Object[]{loadAverage, availablePhysicalMemorySize, maxCpuloadAvg, reservedMemory});
            return 1;
        }
        if (workerWaitingTaskCount > workerExecThreadCount) {
            log.warn("current waiting task count {} is large than worker thread count {}, worker is busy", (Object)workerWaitingTaskCount, (Object)workerExecThreadCount);
            return 2;
        }
        return 0;
    }
}

