/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.common.exception.StorageOperateNoConfiguredException;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.service.storage.StorageOperate;
import org.apache.dolphinscheduler.service.utils.CommonUtils;
import org.slf4j.Logger;

public class TaskExecutionCheckerUtils {
    public static void checkTenantExist(WorkerConfig workerConfig, TaskExecutionContext taskExecutionContext) {
        try {
            boolean osUserExistFlag;
            String tenantCode = taskExecutionContext.getTenantCode();
            if (workerConfig.isTenantDistributedUser() && SystemUtils.IS_OS_LINUX) {
                osUserExistFlag = OSUtils.existTenantCodeInLinux((String)tenantCode);
            } else if (OSUtils.isSudoEnable() && workerConfig.isTenantAutoCreate()) {
                OSUtils.createUserIfAbsent((String)tenantCode);
                osUserExistFlag = OSUtils.getUserList().contains(tenantCode);
            } else {
                osUserExistFlag = OSUtils.getUserList().contains(tenantCode);
            }
            if (!osUserExistFlag) {
                throw new TaskException(String.format("TenantCode: %s doesn't exist", tenantCode));
            }
        }
        catch (TaskException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TaskException(String.format("TenantCode: %s doesn't exist", taskExecutionContext.getTenantCode()));
        }
    }

    public static void createProcessLocalPathIfAbsent(TaskExecutionContext taskExecutionContext) throws TaskException {
        try {
            String execLocalPath = FileUtils.getProcessExecDir((String)taskExecutionContext.getTenantCode(), (long)taskExecutionContext.getProjectCode(), (long)taskExecutionContext.getProcessDefineCode(), (int)taskExecutionContext.getProcessDefineVersion(), (int)taskExecutionContext.getProcessInstanceId(), (int)taskExecutionContext.getTaskInstanceId());
            taskExecutionContext.setExecutePath(execLocalPath);
            TaskExecutionCheckerUtils.createDirectoryWithOwner(Paths.get(execLocalPath, new String[0]), taskExecutionContext.getTenantCode());
        }
        catch (Throwable ex) {
            throw new TaskException("Cannot create process execute dir", ex);
        }
    }

    public static void downloadResourcesIfNeeded(StorageOperate storageOperate, TaskExecutionContext taskExecutionContext, Logger logger) {
        String execLocalPath = taskExecutionContext.getExecutePath();
        Map projectRes = taskExecutionContext.getResources();
        if (MapUtils.isEmpty((Map)projectRes)) {
            return;
        }
        ArrayList downloadFiles = new ArrayList();
        projectRes.forEach((key, value) -> {
            boolean notExist;
            File resFile = new File(execLocalPath, (String)key);
            boolean bl = notExist = !resFile.exists();
            if (notExist) {
                downloadFiles.add(Pair.of((Object)key, (Object)value));
            } else {
                logger.info("file : {} exists ", (Object)resFile.getName());
            }
        });
        if (!downloadFiles.isEmpty() && !PropertyUtils.getResUploadStartupState()) {
            throw new StorageOperateNoConfiguredException("Storage service config does not exist!");
        }
        if (CollectionUtils.isNotEmpty(downloadFiles)) {
            for (Pair fileDownload : downloadFiles) {
                try {
                    String fullName = (String)fileDownload.getLeft();
                    String tenantCode = (String)fileDownload.getRight();
                    String resPath = storageOperate.getResourceFileName(tenantCode, fullName);
                    logger.info("get resource file from path:{}", (Object)resPath);
                    long resourceDownloadStartTime = System.currentTimeMillis();
                    storageOperate.download(tenantCode, resPath, execLocalPath + File.separator + fullName, false, true);
                    WorkerServerMetrics.recordWorkerResourceDownloadTime(System.currentTimeMillis() - resourceDownloadStartTime);
                    WorkerServerMetrics.recordWorkerResourceDownloadSize(Files.size(Paths.get(execLocalPath, fullName)));
                    WorkerServerMetrics.incWorkerResourceDownloadSuccessCount();
                }
                catch (Exception e) {
                    WorkerServerMetrics.incWorkerResourceDownloadFailureCount();
                    throw new TaskException(String.format("Download resource file: %s error", fileDownload), (Throwable)e);
                }
            }
        }
    }

    private static void createDirectoryWithOwner(Path filePath, String tenant) {
        if (Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(filePath, new FileAttribute[0]);
            if (!CommonUtils.isSetTaskDirToTenantEnable()) {
                return;
            }
            UserPrincipalLookupService userPrincipalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            UserPrincipal tenantPrincipal = userPrincipalLookupService.lookupPrincipalByName(tenant);
            Files.setOwner(filePath, tenantPrincipal);
        }
        catch (IOException e) {
            throw new TaskException("Set tenant directory permission failed, tenant: " + tenant, (Throwable)e);
        }
    }
}

