/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker;

import java.util.Collection;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.server.worker.registry.WorkerRegistryClient;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerRpcServer;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"org.apache.dolphinscheduler"})
public class WorkerServer
implements IStoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    @Autowired
    private WorkerRegistryClient workerRegistryClient;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private WorkerRpcServer workerRpcServer;
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private MetricsProvider metricsProvider;

    public static void main(String[] args) {
        WorkerServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Worker-Server");
        SpringApplication.run(WorkerServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void run() {
        this.workerRpcServer.start();
        this.taskPluginManager.loadPlugin();
        this.workerRegistryClient.setRegistryStoppable(this);
        this.workerRegistryClient.start();
        this.messageRetryRunner.start();
        WorkerServerMetrics.registerWorkerCpuUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getTotalCpuUsedPercentage();
        });
        WorkerServerMetrics.registerWorkerMemoryAvailableGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return (systemMetrics.getSystemMemoryMax() - systemMetrics.getSystemMemoryUsed()) / 1024.0 / 1024.0 / 1024.0;
        });
        WorkerServerMetrics.registerWorkerMemoryUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getJvmMemoryUsedPercentage();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!ServerLifeCycleManager.isStopped()) {
                this.close("WorkerServer shutdown hook");
            }
        }));
    }

    public void close(String cause) {
        if (!ServerLifeCycleManager.toStopped()) {
            log.warn("WorkerServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        try (WorkerRpcServer closedWorkerRpcServer = this.workerRpcServer;
             WorkerRegistryClient closedRegistryClient = this.workerRegistryClient;){
            log.info("Worker server is stopping, current cause : {}", (Object)cause);
            this.killAllRunningTasks();
        }
        catch (Exception e) {
            log.error("Worker server stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        log.info("Worker server stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllRunningTasks() {
        Collection<WorkerTaskExecutor> workerTaskExecutors = WorkerTaskExecutorHolder.getAllTaskExecutor();
        if (CollectionUtils.isEmpty(workerTaskExecutors)) {
            return;
        }
        log.info("Worker begin to kill all cache task, task size: {}", (Object)workerTaskExecutors.size());
        int killNumber = 0;
        for (WorkerTaskExecutor workerTaskExecutor : workerTaskExecutors) {
            try {
                TaskExecutionContext taskExecutionContext = workerTaskExecutor.getTaskExecutionContext();
                LogUtils.setTaskInstanceIdMDC((Integer)taskExecutionContext.getTaskInstanceId());
                if (!ProcessUtils.kill((TaskExecutionContext)taskExecutionContext)) continue;
                ++killNumber;
            }
            finally {
                LogUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        }
        log.info("Worker after kill all cache task, task size: {}, killed number: {}", (Object)workerTaskExecutors.size(), (Object)killNumber);
    }
}

