/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectStrategyProperties;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.worker.config.TaskExecuteThreadsFullPolicy;
import org.apache.dolphinscheduler.server.worker.config.TenantConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerServerLoadProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="worker")
public class WorkerConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerConfig.class);
    private int listenPort = 1234;
    private int execThreads = 10;
    private Duration maxHeartbeatInterval = Duration.ofSeconds(10L);
    private int hostWeight = 100;
    private WorkerServerLoadProtection serverLoadProtection = new WorkerServerLoadProtection();
    private ConnectStrategyProperties registryDisconnectStrategy = new ConnectStrategyProperties();
    private String workerAddress;
    private String workerRegistryPath;
    private TaskExecuteThreadsFullPolicy taskExecuteThreadsFullPolicy = TaskExecuteThreadsFullPolicy.REJECT;
    private TenantConfig tenantConfig = new TenantConfig();

    public boolean supports(Class<?> clazz) {
        return WorkerConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        WorkerConfig workerConfig = (WorkerConfig)target;
        if (workerConfig.getExecThreads() <= 0) {
            errors.rejectValue("exec-threads", null, "should be a positive value");
        }
        if (workerConfig.getMaxHeartbeatInterval().getSeconds() <= 0L) {
            errors.rejectValue("max-heartbeat-interval", null, "shoule be a valid duration");
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.getWorkerAddress())) {
            workerConfig.setWorkerAddress(NetUtils.getAddr((int)workerConfig.getListenPort()));
        }
        workerConfig.setWorkerRegistryPath(RegistryNodeType.WORKER.getRegistryPath() + "/" + workerConfig.getWorkerAddress());
        this.printConfig();
    }

    private void printConfig() {
        String config = "\n****************************Worker Configuration**************************************\n  listen-port -> " + this.listenPort + "\n  exec-threads -> " + this.execThreads + "\n  max-heartbeat-interval -> " + this.maxHeartbeatInterval + "\n  host-weight -> " + this.hostWeight + "\n  tenantConfig -> " + this.tenantConfig + "\n  server-load-protection -> " + this.serverLoadProtection + "\n  registry-disconnect-strategy -> " + this.registryDisconnectStrategy + "\n  task-execute-threads-full-policy: " + (Object)((Object)this.taskExecuteThreadsFullPolicy) + "\n  address -> " + this.workerAddress + "\n  registry-path: " + this.workerRegistryPath + "\n****************************Worker Configuration**************************************";
        log.info(config);
    }

    @Generated
    public WorkerConfig() {
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public int getExecThreads() {
        return this.execThreads;
    }

    @Generated
    public Duration getMaxHeartbeatInterval() {
        return this.maxHeartbeatInterval;
    }

    @Generated
    public int getHostWeight() {
        return this.hostWeight;
    }

    @Generated
    public WorkerServerLoadProtection getServerLoadProtection() {
        return this.serverLoadProtection;
    }

    @Generated
    public ConnectStrategyProperties getRegistryDisconnectStrategy() {
        return this.registryDisconnectStrategy;
    }

    @Generated
    public String getWorkerAddress() {
        return this.workerAddress;
    }

    @Generated
    public String getWorkerRegistryPath() {
        return this.workerRegistryPath;
    }

    @Generated
    public TaskExecuteThreadsFullPolicy getTaskExecuteThreadsFullPolicy() {
        return this.taskExecuteThreadsFullPolicy;
    }

    @Generated
    public TenantConfig getTenantConfig() {
        return this.tenantConfig;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setExecThreads(int execThreads) {
        this.execThreads = execThreads;
    }

    @Generated
    public void setMaxHeartbeatInterval(Duration maxHeartbeatInterval) {
        this.maxHeartbeatInterval = maxHeartbeatInterval;
    }

    @Generated
    public void setHostWeight(int hostWeight) {
        this.hostWeight = hostWeight;
    }

    @Generated
    public void setServerLoadProtection(WorkerServerLoadProtection serverLoadProtection) {
        this.serverLoadProtection = serverLoadProtection;
    }

    @Generated
    public void setRegistryDisconnectStrategy(ConnectStrategyProperties registryDisconnectStrategy) {
        this.registryDisconnectStrategy = registryDisconnectStrategy;
    }

    @Generated
    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    @Generated
    public void setWorkerRegistryPath(String workerRegistryPath) {
        this.workerRegistryPath = workerRegistryPath;
    }

    @Generated
    public void setTaskExecuteThreadsFullPolicy(TaskExecuteThreadsFullPolicy taskExecuteThreadsFullPolicy) {
        this.taskExecuteThreadsFullPolicy = taskExecuteThreadsFullPolicy;
    }

    @Generated
    public void setTenantConfig(TenantConfig tenantConfig) {
        this.tenantConfig = tenantConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getExecThreads() != other.getExecThreads()) {
            return false;
        }
        if (this.getHostWeight() != other.getHostWeight()) {
            return false;
        }
        Duration this$maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        Duration other$maxHeartbeatInterval = other.getMaxHeartbeatInterval();
        if (this$maxHeartbeatInterval == null ? other$maxHeartbeatInterval != null : !((Object)this$maxHeartbeatInterval).equals(other$maxHeartbeatInterval)) {
            return false;
        }
        WorkerServerLoadProtection this$serverLoadProtection = this.getServerLoadProtection();
        WorkerServerLoadProtection other$serverLoadProtection = other.getServerLoadProtection();
        if (this$serverLoadProtection == null ? other$serverLoadProtection != null : !((Object)this$serverLoadProtection).equals(other$serverLoadProtection)) {
            return false;
        }
        ConnectStrategyProperties this$registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        ConnectStrategyProperties other$registryDisconnectStrategy = other.getRegistryDisconnectStrategy();
        if (this$registryDisconnectStrategy == null ? other$registryDisconnectStrategy != null : !this$registryDisconnectStrategy.equals(other$registryDisconnectStrategy)) {
            return false;
        }
        String this$workerAddress = this.getWorkerAddress();
        String other$workerAddress = other.getWorkerAddress();
        if (this$workerAddress == null ? other$workerAddress != null : !this$workerAddress.equals(other$workerAddress)) {
            return false;
        }
        String this$workerRegistryPath = this.getWorkerRegistryPath();
        String other$workerRegistryPath = other.getWorkerRegistryPath();
        if (this$workerRegistryPath == null ? other$workerRegistryPath != null : !this$workerRegistryPath.equals(other$workerRegistryPath)) {
            return false;
        }
        TaskExecuteThreadsFullPolicy this$taskExecuteThreadsFullPolicy = this.getTaskExecuteThreadsFullPolicy();
        TaskExecuteThreadsFullPolicy other$taskExecuteThreadsFullPolicy = other.getTaskExecuteThreadsFullPolicy();
        if (this$taskExecuteThreadsFullPolicy == null ? other$taskExecuteThreadsFullPolicy != null : !((Object)((Object)this$taskExecuteThreadsFullPolicy)).equals((Object)other$taskExecuteThreadsFullPolicy)) {
            return false;
        }
        TenantConfig this$tenantConfig = this.getTenantConfig();
        TenantConfig other$tenantConfig = other.getTenantConfig();
        return !(this$tenantConfig == null ? other$tenantConfig != null : !((Object)this$tenantConfig).equals(other$tenantConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getExecThreads();
        result = result * 59 + this.getHostWeight();
        Duration $maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        result = result * 59 + ($maxHeartbeatInterval == null ? 43 : ((Object)$maxHeartbeatInterval).hashCode());
        WorkerServerLoadProtection $serverLoadProtection = this.getServerLoadProtection();
        result = result * 59 + ($serverLoadProtection == null ? 43 : ((Object)$serverLoadProtection).hashCode());
        ConnectStrategyProperties $registryDisconnectStrategy = this.getRegistryDisconnectStrategy();
        result = result * 59 + ($registryDisconnectStrategy == null ? 43 : $registryDisconnectStrategy.hashCode());
        String $workerAddress = this.getWorkerAddress();
        result = result * 59 + ($workerAddress == null ? 43 : $workerAddress.hashCode());
        String $workerRegistryPath = this.getWorkerRegistryPath();
        result = result * 59 + ($workerRegistryPath == null ? 43 : $workerRegistryPath.hashCode());
        TaskExecuteThreadsFullPolicy $taskExecuteThreadsFullPolicy = this.getTaskExecuteThreadsFullPolicy();
        result = result * 59 + ($taskExecuteThreadsFullPolicy == null ? 43 : ((Object)((Object)$taskExecuteThreadsFullPolicy)).hashCode());
        TenantConfig $tenantConfig = this.getTenantConfig();
        result = result * 59 + ($tenantConfig == null ? 43 : ((Object)$tenantConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerConfig(listenPort=" + this.getListenPort() + ", execThreads=" + this.getExecThreads() + ", maxHeartbeatInterval=" + this.getMaxHeartbeatInterval() + ", hostWeight=" + this.getHostWeight() + ", serverLoadProtection=" + this.getServerLoadProtection() + ", registryDisconnectStrategy=" + this.getRegistryDisconnectStrategy() + ", workerAddress=" + this.getWorkerAddress() + ", workerRegistryPath=" + this.getWorkerRegistryPath() + ", taskExecuteThreadsFullPolicy=" + (Object)((Object)this.getTaskExecuteThreadsFullPolicy()) + ", tenantConfig=" + this.getTenantConfig() + ")";
    }
}

