/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import lombok.Generated;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServerLoadProtection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerServerLoadProtection.class);
    private boolean enabled = true;
    private double maxCpuUsagePercentageThresholds = 0.7;
    private double maxJVMMemoryUsagePercentageThresholds = 0.7;
    private double maxSystemMemoryUsagePercentageThresholds = 0.7;
    private double maxDiskUsagePercentageThresholds = 0.7;

    public boolean isOverload(SystemMetrics systemMetrics) {
        if (!this.enabled) {
            return false;
        }
        if (systemMetrics.getTotalCpuUsedPercentage() > this.maxCpuUsagePercentageThresholds) {
            log.info("Worker OverLoad: the TotalCpuUsedPercentage: {} is over then the MaxCpuUsagePercentageThresholds {}", (Object)systemMetrics.getTotalCpuUsedPercentage(), (Object)this.maxCpuUsagePercentageThresholds);
            return true;
        }
        if (systemMetrics.getJvmMemoryUsedPercentage() > this.maxJVMMemoryUsagePercentageThresholds) {
            log.info("Worker OverLoad: the JvmMemoryUsedPercentage: {} is over then the maxCpuUsagePercentageThresholds {}", (Object)systemMetrics.getJvmMemoryUsedPercentage(), (Object)this.maxJVMMemoryUsagePercentageThresholds);
            return true;
        }
        if (systemMetrics.getDiskUsedPercentage() > this.maxDiskUsagePercentageThresholds) {
            log.info("Worker OverLoad: the DiskUsedPercentage: {} is over then the MaxCpuUsagePercentageThresholds {}", (Object)systemMetrics.getDiskUsedPercentage(), (Object)this.maxDiskUsagePercentageThresholds);
            return true;
        }
        if (systemMetrics.getSystemMemoryUsedPercentage() > this.maxSystemMemoryUsagePercentageThresholds) {
            log.info("Worker OverLoad: the SystemMemoryUsedPercentage: {} is over then the MaxSystemMemoryUsagePercentageThresholds {}", (Object)systemMetrics.getSystemMemoryUsedPercentage(), (Object)this.maxSystemMemoryUsagePercentageThresholds);
            return true;
        }
        return false;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public double getMaxCpuUsagePercentageThresholds() {
        return this.maxCpuUsagePercentageThresholds;
    }

    @Generated
    public double getMaxJVMMemoryUsagePercentageThresholds() {
        return this.maxJVMMemoryUsagePercentageThresholds;
    }

    @Generated
    public double getMaxSystemMemoryUsagePercentageThresholds() {
        return this.maxSystemMemoryUsagePercentageThresholds;
    }

    @Generated
    public double getMaxDiskUsagePercentageThresholds() {
        return this.maxDiskUsagePercentageThresholds;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setMaxCpuUsagePercentageThresholds(double maxCpuUsagePercentageThresholds) {
        this.maxCpuUsagePercentageThresholds = maxCpuUsagePercentageThresholds;
    }

    @Generated
    public void setMaxJVMMemoryUsagePercentageThresholds(double maxJVMMemoryUsagePercentageThresholds) {
        this.maxJVMMemoryUsagePercentageThresholds = maxJVMMemoryUsagePercentageThresholds;
    }

    @Generated
    public void setMaxSystemMemoryUsagePercentageThresholds(double maxSystemMemoryUsagePercentageThresholds) {
        this.maxSystemMemoryUsagePercentageThresholds = maxSystemMemoryUsagePercentageThresholds;
    }

    @Generated
    public void setMaxDiskUsagePercentageThresholds(double maxDiskUsagePercentageThresholds) {
        this.maxDiskUsagePercentageThresholds = maxDiskUsagePercentageThresholds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerServerLoadProtection)) {
            return false;
        }
        WorkerServerLoadProtection other = (WorkerServerLoadProtection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getMaxCpuUsagePercentageThresholds(), other.getMaxCpuUsagePercentageThresholds()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxJVMMemoryUsagePercentageThresholds(), other.getMaxJVMMemoryUsagePercentageThresholds()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxSystemMemoryUsagePercentageThresholds(), other.getMaxSystemMemoryUsagePercentageThresholds()) != 0) {
            return false;
        }
        return Double.compare(this.getMaxDiskUsagePercentageThresholds(), other.getMaxDiskUsagePercentageThresholds()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerServerLoadProtection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $maxCpuUsagePercentageThresholds = Double.doubleToLongBits(this.getMaxCpuUsagePercentageThresholds());
        result = result * 59 + (int)($maxCpuUsagePercentageThresholds >>> 32 ^ $maxCpuUsagePercentageThresholds);
        long $maxJVMMemoryUsagePercentageThresholds = Double.doubleToLongBits(this.getMaxJVMMemoryUsagePercentageThresholds());
        result = result * 59 + (int)($maxJVMMemoryUsagePercentageThresholds >>> 32 ^ $maxJVMMemoryUsagePercentageThresholds);
        long $maxSystemMemoryUsagePercentageThresholds = Double.doubleToLongBits(this.getMaxSystemMemoryUsagePercentageThresholds());
        result = result * 59 + (int)($maxSystemMemoryUsagePercentageThresholds >>> 32 ^ $maxSystemMemoryUsagePercentageThresholds);
        long $maxDiskUsagePercentageThresholds = Double.doubleToLongBits(this.getMaxDiskUsagePercentageThresholds());
        result = result * 59 + (int)($maxDiskUsagePercentageThresholds >>> 32 ^ $maxDiskUsagePercentageThresholds);
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerServerLoadProtection(enabled=" + this.isEnabled() + ", maxCpuUsagePercentageThresholds=" + this.getMaxCpuUsagePercentageThresholds() + ", maxJVMMemoryUsagePercentageThresholds=" + this.getMaxJVMMemoryUsagePercentageThresholds() + ", maxSystemMemoryUsagePercentageThresholds=" + this.getMaxSystemMemoryUsagePercentageThresholds() + ", maxDiskUsagePercentageThresholds=" + this.getMaxDiskUsagePercentageThresholds() + ")";
    }

    @Generated
    public WorkerServerLoadProtection() {
    }

    @Generated
    public WorkerServerLoadProtection(boolean enabled, double maxCpuUsagePercentageThresholds, double maxJVMMemoryUsagePercentageThresholds, double maxSystemMemoryUsagePercentageThresholds, double maxDiskUsagePercentageThresholds) {
        this.enabled = enabled;
        this.maxCpuUsagePercentageThresholds = maxCpuUsagePercentageThresholds;
        this.maxJVMMemoryUsagePercentageThresholds = maxJVMMemoryUsagePercentageThresholds;
        this.maxSystemMemoryUsagePercentageThresholds = maxSystemMemoryUsagePercentageThresholds;
        this.maxDiskUsagePercentageThresholds = maxDiskUsagePercentageThresholds;
    }
}

