/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import com.google.common.base.Objects;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.message.TaskInstanceExecutionEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MessageRetryRunner
extends BaseDaemonThread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageRetryRunner.class);
    private static final long MESSAGE_RETRY_WINDOW = Duration.ofMinutes(5L).toMillis();
    @Lazy
    @Autowired
    private List<TaskInstanceExecutionEventSender> messageSenders;
    private final Map<ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType, TaskInstanceExecutionEventSender<ITaskInstanceExecutionEvent>> messageSenderMap = new HashMap<ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType, TaskInstanceExecutionEventSender<ITaskInstanceExecutionEvent>>();
    private final Map<Integer, List<TaskInstanceMessage>> needToRetryMessages = new ConcurrentHashMap<Integer, List<TaskInstanceMessage>>();

    protected MessageRetryRunner() {
        super("WorkerMessageRetryRunnerThread");
    }

    public synchronized void start() {
        log.info("Message retry runner staring");
        this.messageSenders.forEach(messageSender -> {
            this.messageSenderMap.put(messageSender.getMessageType(), (TaskInstanceExecutionEventSender<ITaskInstanceExecutionEvent>)messageSender);
            log.info("Injected message sender: {}", (Object)messageSender.getClass().getSimpleName());
        });
        super.start();
        log.info("Message retry runner started");
    }

    public void addRetryMessage(int taskInstanceId, @NonNull ITaskInstanceExecutionEvent iTaskInstanceExecutionEvent) {
        if (iTaskInstanceExecutionEvent == null) {
            throw new NullPointerException("iTaskInstanceExecutionEvent is marked non-null but is null");
        }
        this.needToRetryMessages.computeIfAbsent(taskInstanceId, k -> Collections.synchronizedList(new ArrayList())).add(TaskInstanceMessage.of(taskInstanceId, iTaskInstanceExecutionEvent.getEventType(), iTaskInstanceExecutionEvent));
    }

    public void removeRetryMessage(int taskInstanceId, @NonNull ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        List<TaskInstanceMessage> taskInstanceMessages = this.needToRetryMessages.get(taskInstanceId);
        if (taskInstanceMessages != null) {
            taskInstanceMessages.remove(TaskInstanceMessage.of(taskInstanceId, eventType, null));
        }
    }

    public void removeRetryMessages(int taskInstanceId) {
        this.needToRetryMessages.remove(taskInstanceId);
    }

    public boolean updateMessageHost(int taskInstanceId, String messageReceiverHost) {
        List<TaskInstanceMessage> taskInstanceMessages = this.needToRetryMessages.get(taskInstanceId);
        if (CollectionUtils.isEmpty(taskInstanceMessages)) {
            return false;
        }
        taskInstanceMessages.forEach(taskInstanceMessage -> taskInstanceMessage.getEvent().setWorkflowInstanceHost(messageReceiverHost));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!ServerLifeCycleManager.isStopped()) {
            try {
                if (MapUtils.isEmpty(this.needToRetryMessages)) {
                    Thread.sleep(MESSAGE_RETRY_WINDOW);
                }
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<Integer, List<TaskInstanceMessage>>> iterator = this.needToRetryMessages.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, List<TaskInstanceMessage>> taskEntry = iterator.next();
                    Integer taskInstanceId = taskEntry.getKey();
                    List<TaskInstanceMessage> taskInstanceMessages = taskEntry.getValue();
                    if (taskInstanceMessages.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
                    try {
                        for (TaskInstanceMessage taskInstanceMessage : taskInstanceMessages) {
                            ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType = taskInstanceMessage.getEventType();
                            ITaskInstanceExecutionEvent event = taskInstanceMessage.getEvent();
                            if (now - event.getEventSendTime() <= MESSAGE_RETRY_WINDOW) continue;
                            log.info("Begin retry send message to master, event: {}", (Object)event);
                            event.setEventSendTime(now);
                            this.messageSenderMap.get(eventType).sendEvent(event);
                            log.info("Success send message to master, event: {}", (Object)event);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Retry send message to master error", (Throwable)e);
                    }
                    finally {
                        LogUtils.removeTaskInstanceIdMDC();
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException instance) {
                log.warn("The message retry thread is interrupted, will break this loop", (Throwable)instance);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                log.error("Retry send message failed, get an known exception.", (Throwable)ex);
            }
        }
    }

    public void clearMessage() {
        this.needToRetryMessages.clear();
    }

    public static class TaskInstanceMessage {
        private long taskInstanceId;
        private ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType;
        private ITaskInstanceExecutionEvent event;

        public static TaskInstanceMessage of(long taskInstanceId, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType, ITaskInstanceExecutionEvent event) {
            TaskInstanceMessage taskInstanceMessage = new TaskInstanceMessage();
            taskInstanceMessage.setTaskInstanceId(taskInstanceId);
            taskInstanceMessage.setEventType(eventType);
            taskInstanceMessage.setEvent(event);
            return taskInstanceMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskInstanceMessage that = (TaskInstanceMessage)o;
            return this.taskInstanceId == that.taskInstanceId && this.eventType == that.eventType;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.taskInstanceId, this.eventType});
        }

        @Generated
        public TaskInstanceMessage() {
        }

        @Generated
        public long getTaskInstanceId() {
            return this.taskInstanceId;
        }

        @Generated
        public ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType getEventType() {
            return this.eventType;
        }

        @Generated
        public ITaskInstanceExecutionEvent getEvent() {
            return this.event;
        }

        @Generated
        public void setTaskInstanceId(long taskInstanceId) {
            this.taskInstanceId = taskInstanceId;
        }

        @Generated
        public void setEventType(ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType) {
            this.eventType = eventType;
        }

        @Generated
        public void setEvent(ITaskInstanceExecutionEvent event) {
            this.event = event;
        }

        @Generated
        public String toString() {
            return "MessageRetryRunner.TaskInstanceMessage(taskInstanceId=" + this.getTaskInstanceId() + ", eventType=" + this.getEventType() + ", event=" + this.getEvent() + ")";
        }
    }
}

