/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import lombok.NonNull;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceExecutionEventListener;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionInfoEvent;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.message.TaskInstanceExecutionEventSender;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionInfoUpdateEventSender
implements TaskInstanceExecutionEventSender<TaskInstanceExecutionInfoEvent> {
    @Override
    public void sendEvent(TaskInstanceExecutionInfoEvent taskInstanceExecutionInfoEvent) {
        ITaskInstanceExecutionEventListener iTaskInstanceExecutionEventListener = (ITaskInstanceExecutionEventListener)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstanceExecutionInfoEvent.getWorkflowInstanceHost(), ITaskInstanceExecutionEventListener.class);
        iTaskInstanceExecutionEventListener.onTaskInstanceExecutionInfoUpdate(taskInstanceExecutionInfoEvent);
    }

    @Override
    public TaskInstanceExecutionInfoEvent buildEvent(@NonNull TaskExecutionContext taskExecutionContext) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        TaskInstanceExecutionInfoEvent taskUpdatePidRequest = new TaskInstanceExecutionInfoEvent();
        taskUpdatePidRequest.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskUpdatePidRequest.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskUpdatePidRequest.setWorkflowInstanceHost(taskExecutionContext.getWorkflowInstanceHost());
        taskUpdatePidRequest.setTaskInstanceHost(taskExecutionContext.getHost());
        taskUpdatePidRequest.setStartTime(taskExecutionContext.getStartTime());
        return taskUpdatePidRequest;
    }

    @Override
    public ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType getMessageType() {
        return ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING_INFO;
    }
}

