/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.message;

import lombok.NonNull;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.master.ITaskInstanceExecutionEventListener;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.extract.master.transportor.TaskInstanceExecutionRunningEvent;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.message.TaskInstanceExecutionEventSender;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionRunningEventSender
implements TaskInstanceExecutionEventSender<TaskInstanceExecutionRunningEvent> {
    @Override
    public void sendEvent(TaskInstanceExecutionRunningEvent taskInstanceExecutionRunningEvent) {
        ITaskInstanceExecutionEventListener iTaskInstanceExecutionEventListener = (ITaskInstanceExecutionEventListener)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)taskInstanceExecutionRunningEvent.getWorkflowInstanceHost(), ITaskInstanceExecutionEventListener.class);
        iTaskInstanceExecutionEventListener.onTaskInstanceExecutionRunning(taskInstanceExecutionRunningEvent);
    }

    @Override
    public TaskInstanceExecutionRunningEvent buildEvent(@NonNull TaskExecutionContext taskExecutionContext) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        TaskInstanceExecutionRunningEvent taskExecuteRunningMessage = new TaskInstanceExecutionRunningEvent();
        taskExecuteRunningMessage.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
        taskExecuteRunningMessage.setProcessInstanceId(taskExecutionContext.getProcessInstanceId());
        taskExecuteRunningMessage.setStatus(taskExecutionContext.getCurrentExecutionStatus());
        taskExecuteRunningMessage.setLogPath(taskExecutionContext.getLogPath());
        taskExecuteRunningMessage.setWorkflowInstanceHost(taskExecutionContext.getWorkflowInstanceHost());
        taskExecuteRunningMessage.setTaskInstanceHost(taskExecutionContext.getHost());
        taskExecuteRunningMessage.setStartTime(taskExecutionContext.getStartTime());
        taskExecuteRunningMessage.setExecutePath(taskExecutionContext.getExecutePath());
        taskExecuteRunningMessage.setAppIds(taskExecutionContext.getAppIds());
        return taskExecuteRunningMessage;
    }

    @Override
    public ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType getMessageType() {
        return ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING;
    }
}

