/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;

public final class WorkerServerMetrics {
    private static final Counter workerOverloadCounter = Counter.builder((String)"ds.worker.overload.count").description("overloaded workers count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter workerFullSubmitQueueCounter = Counter.builder((String)"ds.worker.full.submit.queue.count").description("full worker submit queues count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter workerResourceDownloadSuccessCounter = Counter.builder((String)"ds.worker.resource.download.count").tag("status", "success").description("worker resource download success count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter workerResourceDownloadFailCounter = Counter.builder((String)"ds.worker.resource.download.count").tag("status", "fail").description("worker resource download failure count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Timer workerResourceDownloadDurationTimer = Timer.builder((String)"ds.worker.resource.download.duration").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).publishPercentileHistogram().description("time cost of resource download on workers").register((MeterRegistry)Metrics.globalRegistry);
    private static final DistributionSummary workerResourceDownloadSizeDistribution = DistributionSummary.builder((String)"ds.worker.resource.download.size").baseUnit("bytes").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).publishPercentileHistogram().description("size of downloaded resource files on worker").register((MeterRegistry)Metrics.globalRegistry);

    public static void incWorkerOverloadCount() {
        workerOverloadCounter.increment();
    }

    public static void incWorkerSubmitQueueIsFullCount() {
        workerFullSubmitQueueCounter.increment();
    }

    public static void incWorkerResourceDownloadSuccessCount() {
        workerResourceDownloadSuccessCounter.increment();
    }

    public static void incWorkerResourceDownloadFailureCount() {
        workerResourceDownloadFailCounter.increment();
    }

    public static void recordWorkerResourceDownloadTime(long milliseconds) {
        workerResourceDownloadDurationTimer.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void recordWorkerResourceDownloadSize(long size) {
        workerResourceDownloadSizeDistribution.record((double)size);
    }

    public static void registerWorkerTaskTotalGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.task", supplier).description("total number of tasks on worker").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerWorkerExecuteQueueSizeGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.execute.queue.size", supplier).description("worker execute queue size").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerWorkerActiveExecuteThreadGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.active.execute.thread", supplier).description("number of active task execute threads on worker").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerWorkerMemoryAvailableGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.memory.available", supplier).description("worker memory available").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerWorkerCpuUsageGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.cpu.usage", supplier).description("worker cpu usage").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerWorkerMemoryUsageGauge(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.memory.usage", supplier).description("worker memory usage").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void registerUncachedException(Supplier<Number> supplier) {
        Gauge.builder((String)"ds.worker.uncached.exception", supplier).description("number of uncached exception").register((MeterRegistry)Metrics.globalRegistry);
    }

    @Generated
    private WorkerServerMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

