/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConnectionStateListener
implements ConnectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerConnectionStateListener.class);
    private final WorkerConfig workerConfig;
    private final WorkerConnectStrategy workerConnectStrategy;

    public WorkerConnectionStateListener(@NonNull WorkerConfig workerConfig, @NonNull WorkerConnectStrategy workerConnectStrategy) {
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (workerConnectStrategy == null) {
            throw new NullPointerException("workerConnectStrategy is marked non-null but is null");
        }
        this.workerConfig = workerConfig;
        this.workerConnectStrategy = workerConnectStrategy;
    }

    public void onUpdate(ConnectionState state) {
        log.info("Worker received a {} event from registry, the current server state is {}", (Object)state, (Object)ServerLifeCycleManager.getServerStatus());
        switch (state) {
            case CONNECTED: {
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                this.workerConnectStrategy.reconnect();
                break;
            }
            case DISCONNECTED: {
                this.workerConnectStrategy.disconnect();
            }
        }
    }
}

