/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleException;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.StrategyType;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.registry.WorkerConnectStrategy;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="worker.registry-disconnect-strategy", name={"strategy"}, havingValue="waiting")
public class WorkerWaitingStrategy
implements WorkerConnectStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerWaitingStrategy.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private WorkerTaskExecutorThreadPool workerManagerThread;

    public WorkerWaitingStrategy(@NonNull WorkerConfig workerConfig, @NonNull RegistryClient registryClient, @NonNull MessageRetryRunner messageRetryRunner, @NonNull WorkerTaskExecutorThreadPool workerManagerThread) {
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (messageRetryRunner == null) {
            throw new NullPointerException("messageRetryRunner is marked non-null but is null");
        }
        if (workerManagerThread == null) {
            throw new NullPointerException("workerManagerThread is marked non-null but is null");
        }
        this.workerConfig = workerConfig;
        this.registryClient = registryClient;
        this.messageRetryRunner = messageRetryRunner;
        this.workerManagerThread = workerManagerThread;
    }

    public void disconnect() {
        try {
            ServerLifeCycleManager.toWaiting();
            this.clearWorkerResource();
            Duration maxWaitingTime = this.workerConfig.getRegistryDisconnectStrategy().getMaxWaitingTime();
            try {
                log.info("Worker disconnect from registry will try to reconnect in {} s", (Object)maxWaitingTime.getSeconds());
                this.registryClient.connectUntilTimeout(maxWaitingTime);
            }
            catch (RegistryException ex) {
                throw new ServerLifeCycleException(String.format("Waiting to reconnect to registry in %s failed", maxWaitingTime), (Throwable)ex);
            }
        }
        catch (ServerLifeCycleException e) {
            String errorMessage = String.format("Disconnect from registry and change the current status to waiting error, the current server state is %s, will stop the current server", ServerLifeCycleManager.getServerStatus());
            log.error(errorMessage, (Throwable)e);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (RegistryException ex) {
            String errorMessage = "Disconnect from registry and waiting to reconnect failed, will stop the server";
            log.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
        catch (Exception ex) {
            String errorMessage = "Disconnect from registry and get an unknown exception, will stop the server";
            log.error(errorMessage, (Throwable)ex);
            this.registryClient.getStoppable().stop(errorMessage);
        }
    }

    public void reconnect() {
        if (ServerLifeCycleManager.isRunning()) {
            log.info("no need to reconnect, as the current server status is running");
        } else {
            try {
                ServerLifeCycleManager.recoverFromWaiting();
                log.info("Recover from waiting success, the current server status is {}", (Object)ServerLifeCycleManager.getServerStatus());
            }
            catch (Exception e) {
                String errorMessage = String.format("Recover from waiting failed, the current server status is %s, will stop the server", ServerLifeCycleManager.getServerStatus());
                log.error(errorMessage, (Throwable)e);
                this.registryClient.getStoppable().stop(errorMessage);
            }
        }
    }

    public StrategyType getStrategyType() {
        return StrategyType.WAITING;
    }

    private void clearWorkerResource() {
        this.workerManagerThread.clearTask();
        WorkerTaskExecutorHolder.clear();
        log.warn("Worker server clear the tasks due to lost connection from registry");
        this.messageRetryRunner.clearMessage();
        log.warn("Worker server clear the retry message due to lost connection from registry");
    }
}

