/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.common.transportor.GetAppIdRequest;
import org.apache.dolphinscheduler.extract.common.transportor.GetAppIdResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryResponse;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkerLogServiceImpl
implements ILogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerLogServiceImpl.class);

    public TaskInstanceLogFileDownloadResponse getTaskInstanceWholeLogFileBytes(TaskInstanceLogFileDownloadRequest taskInstanceLogFileDownloadRequest) {
        byte[] bytes = LogUtils.getFileContentBytes((String)taskInstanceLogFileDownloadRequest.getTaskInstanceLogAbsolutePath());
        return new TaskInstanceLogFileDownloadResponse(bytes);
    }

    public TaskInstanceLogPageQueryResponse pageQueryTaskInstanceLog(TaskInstanceLogPageQueryRequest taskInstanceLogPageQueryRequest) {
        List lines = LogUtils.readPartFileContent((String)taskInstanceLogPageQueryRequest.getTaskInstanceLogAbsolutePath(), (int)taskInstanceLogPageQueryRequest.getSkipLineNum(), (int)taskInstanceLogPageQueryRequest.getLimit());
        String logContent = LogUtils.rollViewLogLines((List)lines);
        return new TaskInstanceLogPageQueryResponse(logContent);
    }

    public GetAppIdResponse getAppId(GetAppIdRequest getAppIdRequest) {
        String appInfoPath = null;
        WorkerTaskExecutor workerTaskExecutor = WorkerTaskExecutorHolder.get(getAppIdRequest.getTaskInstanceId());
        if (workerTaskExecutor != null) {
            appInfoPath = workerTaskExecutor.getTaskExecutionContext().getAppInfoPath();
        }
        String logPath = getAppIdRequest.getLogPath();
        List appIds = org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils.getAppIds((String)logPath, (String)appInfoPath, (String)PropertyUtils.getString((String)"appId.collect", (String)"log"));
        return new GetAppIdResponse(appIds);
    }

    public void removeTaskInstanceLog(String taskInstanceLogAbsolutePath) {
        FileUtils.deleteFile((String)taskInstanceLogAbsolutePath);
    }
}

