/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.rpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.message.TaskInstanceExecutionEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkerMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerMessageSender.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;
    @Autowired
    private List<TaskInstanceExecutionEventSender> messageSenders;
    private final Map<ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType, TaskInstanceExecutionEventSender> messageSenderMap = new HashMap<ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType, TaskInstanceExecutionEventSender>();

    @PostConstruct
    public void init() {
        this.messageSenders.forEach(messageSender -> this.messageSenderMap.put(messageSender.getMessageType(), (TaskInstanceExecutionEventSender)messageSender));
    }

    public void sendMessageWithRetry(@NonNull TaskExecutionContext taskExecutionContext, @NonNull ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType eventType) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        TaskInstanceExecutionEventSender messageSender = this.messageSenderMap.get(eventType);
        if (messageSender == null) {
            throw new IllegalArgumentException("The messageType is invalidated, messageType: " + eventType);
        }
        Object iTaskInstanceExecutionEvent = messageSender.buildEvent(taskExecutionContext);
        try {
            this.messageRetryRunner.addRetryMessage(taskExecutionContext.getTaskInstanceId(), (ITaskInstanceExecutionEvent)iTaskInstanceExecutionEvent);
            messageSender.sendEvent(iTaskInstanceExecutionEvent);
        }
        catch (Exception e) {
            log.error("Send message error, eventType: {}, event: {}", (Object)eventType, iTaskInstanceExecutionEvent);
        }
    }

    public void sendMessage(@NonNull TaskExecutionContext taskExecutionContext, @NonNull ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType taskInstanceExecutionEventType) {
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        if (taskInstanceExecutionEventType == null) {
            throw new NullPointerException("taskInstanceExecutionEventType is marked non-null but is null");
        }
        TaskInstanceExecutionEventSender messageSender = this.messageSenderMap.get(taskInstanceExecutionEventType);
        if (messageSender == null) {
            throw new IllegalArgumentException("The eventType is invalidated, eventType: " + taskInstanceExecutionEventType);
        }
        Object iTaskInstanceExecutionEvent = messageSender.buildEvent(taskExecutionContext);
        try {
            messageSender.sendEvent(iTaskInstanceExecutionEvent);
        }
        catch (Exception e) {
            log.error("Send message error, eventType: {}, event: {}", (Object)taskInstanceExecutionEventType, iTaskInstanceExecutionEvent);
        }
    }
}

