/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ApplicationInfo;
import org.apache.dolphinscheduler.server.worker.rpc.WorkerMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCallbackImpl
implements TaskCallBack {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskCallbackImpl.class);
    private final WorkerMessageSender workerMessageSender;
    private final TaskExecutionContext taskExecutionContext;

    public TaskCallbackImpl(WorkerMessageSender workerMessageSender, TaskExecutionContext taskExecutionContext) {
        this.workerMessageSender = workerMessageSender;
        this.taskExecutionContext = taskExecutionContext;
    }

    public void updateRemoteApplicationInfo(int taskInstanceId, ApplicationInfo applicationInfo) {
        this.taskExecutionContext.setAppIds(applicationInfo.getAppIds());
        this.workerMessageSender.sendMessageWithRetry(this.taskExecutionContext, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING_INFO);
    }

    public void updateTaskInstanceInfo(int taskInstanceId) {
        this.workerMessageSender.sendMessageWithRetry(this.taskExecutionContext, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING_INFO);
    }

    @Generated
    public static TaskCallbackImplBuilder builder() {
        return new TaskCallbackImplBuilder();
    }

    @Generated
    public static class TaskCallbackImplBuilder {
        @Generated
        private WorkerMessageSender workerMessageSender;
        @Generated
        private TaskExecutionContext taskExecutionContext;

        @Generated
        TaskCallbackImplBuilder() {
        }

        @Generated
        public TaskCallbackImplBuilder workerMessageSender(WorkerMessageSender workerMessageSender) {
            this.workerMessageSender = workerMessageSender;
            return this;
        }

        @Generated
        public TaskCallbackImplBuilder taskExecutionContext(TaskExecutionContext taskExecutionContext) {
            this.taskExecutionContext = taskExecutionContext;
            return this;
        }

        @Generated
        public TaskCallbackImpl build() {
            return new TaskCallbackImpl(this.workerMessageSender, this.taskExecutionContext);
        }

        @Generated
        public String toString() {
            return "TaskCallbackImpl.TaskCallbackImplBuilder(workerMessageSender=" + this.workerMessageSender + ", taskExecutionContext=" + this.taskExecutionContext + ")";
        }
    }
}

