/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;

public class WorkerTaskExecutorHolder {
    private static final Map<Integer, WorkerTaskExecutor> workerTaskExecutorMap = new HashMap<Integer, WorkerTaskExecutor>();

    public static void put(WorkerTaskExecutor workerTaskExecutor) {
        int taskInstanceId = workerTaskExecutor.getTaskExecutionContext().getTaskInstanceId();
        if (workerTaskExecutorMap.containsKey(taskInstanceId)) {
            throw new IllegalArgumentException("TaskInstance: " + taskInstanceId + " already exists");
        }
        workerTaskExecutorMap.put(taskInstanceId, workerTaskExecutor);
    }

    public static WorkerTaskExecutor get(int taskInstanceId) {
        return workerTaskExecutorMap.get(taskInstanceId);
    }

    public static WorkerTaskExecutor remove(int taskInstanceId) {
        return workerTaskExecutorMap.remove(taskInstanceId);
    }

    public static void clear() {
        workerTaskExecutorMap.clear();
    }

    public static Collection<WorkerTaskExecutor> getAllTaskExecutor() {
        return workerTaskExecutorMap.values();
    }
}

