/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.worker.config.TaskExecuteThreadsFullPolicy;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkerTaskExecutorThreadPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerTaskExecutorThreadPool.class);
    private final ThreadPoolExecutor threadPoolExecutor;
    private final WorkerConfig workerConfig;

    public WorkerTaskExecutorThreadPool(WorkerConfig workerConfig) {
        this.threadPoolExecutor = ThreadUtils.newDaemonFixedThreadExecutor((String)"WorkerTaskExecutorThreadPool", (int)workerConfig.getExecThreads());
        this.workerConfig = workerConfig;
        WorkerServerMetrics.registerWorkerExecuteQueueSizeGauge(this::getWaitingTaskExecutorSize);
        WorkerServerMetrics.registerWorkerActiveExecuteThreadGauge(this::getRunningTaskExecutorSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitWorkerTaskExecutor(WorkerTaskExecutor workerTaskExecutor) {
        Class<WorkerTaskExecutorThreadPool> clazz = WorkerTaskExecutorThreadPool.class;
        synchronized (WorkerTaskExecutorThreadPool.class) {
            if (TaskExecuteThreadsFullPolicy.CONTINUE.equals((Object)this.workerConfig.getTaskExecuteThreadsFullPolicy())) {
                WorkerTaskExecutorHolder.put(workerTaskExecutor);
                this.threadPoolExecutor.execute(workerTaskExecutor);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            if (this.isOverload()) {
                log.warn("WorkerTaskExecutorThreadPool is overload, cannot submit new WorkerTaskExecutor");
                WorkerServerMetrics.incWorkerSubmitQueueIsFullCount();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            WorkerTaskExecutorHolder.put(workerTaskExecutor);
            this.threadPoolExecutor.execute(workerTaskExecutor);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public boolean isOverload() {
        return this.threadPoolExecutor.getQueue().size() > 0;
    }

    public int getWaitingTaskExecutorSize() {
        return this.threadPoolExecutor.getQueue().size();
    }

    public int getRunningTaskExecutorSize() {
        return this.threadPoolExecutor.getActiveCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTaskBeforeExecuteByInstanceId(Integer taskInstanceId) {
        Class<WorkerTaskExecutorThreadPool> clazz = WorkerTaskExecutorThreadPool.class;
        synchronized (WorkerTaskExecutorThreadPool.class) {
            WorkerTaskExecutor workerTaskExecutor = WorkerTaskExecutorHolder.get(taskInstanceId);
            this.threadPoolExecutor.remove(workerTaskExecutor);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void clearTask() {
        this.threadPoolExecutor.getQueue().clear();
    }
}

