/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.listener;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceExecutionFinishEventAck;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.listener.ITaskInstanceExecutionEventAckListenFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionFinishEventAckListenFunction
implements ITaskInstanceExecutionEventAckListenFunction<TaskInstanceExecutionFinishEventAck> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceExecutionFinishEventAckListenFunction.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    @Override
    public void handleTaskInstanceExecutionEventAck(TaskInstanceExecutionFinishEventAck taskInstanceExecutionFinishEventAck) {
        try {
            int taskInstanceId = taskInstanceExecutionFinishEventAck.getTaskInstanceId();
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            log.info("Receive TaskInstanceExecutionFinishEventAck: {}", (Object)taskInstanceExecutionFinishEventAck);
            if (taskInstanceExecutionFinishEventAck.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(taskInstanceId, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.FINISH);
            } else {
                log.warn("TaskInstanceExecutionFinishEventAck failed: {}", (Object)taskInstanceExecutionFinishEventAck);
            }
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
        }
    }
}

