/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.listener;

import javax.annotation.Resource;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceExecutionInfoEventAck;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.listener.ITaskInstanceExecutionEventAckListenFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionInfoEventAckListenFunction
implements ITaskInstanceExecutionEventAckListenFunction<TaskInstanceExecutionInfoEventAck> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceExecutionInfoEventAckListenFunction.class);
    @Resource
    private MessageRetryRunner messageRetryRunner;

    @Override
    public void handleTaskInstanceExecutionEventAck(TaskInstanceExecutionInfoEventAck taskInstanceExecutionInfoEventAck) {
        try {
            int taskInstanceId = taskInstanceExecutionInfoEventAck.getTaskInstanceId();
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            log.info("Receive TaskInstanceExecutionInfoEventAck: {}", (Object)taskInstanceExecutionInfoEventAck);
            if (taskInstanceExecutionInfoEventAck.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(taskInstanceId, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING_INFO);
            } else {
                log.warn("TaskInstanceExecutionInfoEventAck failed: {}", (Object)taskInstanceExecutionInfoEventAck);
            }
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
        }
    }
}

