/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.listener;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.master.transportor.ITaskInstanceExecutionEvent;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceExecutionRunningEventAck;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.listener.ITaskInstanceExecutionEventAckListenFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceExecutionRunningEventAckListenFunction
implements ITaskInstanceExecutionEventAckListenFunction<TaskInstanceExecutionRunningEventAck> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceExecutionRunningEventAckListenFunction.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    @Override
    public void handleTaskInstanceExecutionEventAck(TaskInstanceExecutionRunningEventAck taskInstanceExecutionRunningEventAck) {
        try {
            int taskInstanceId = taskInstanceExecutionRunningEventAck.getTaskInstanceId();
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            log.info("Receive TaskInstanceExecutionRunningEventAck: {}", (Object)taskInstanceExecutionRunningEventAck);
            if (taskInstanceExecutionRunningEventAck.isSuccess()) {
                this.messageRetryRunner.removeRetryMessage(taskInstanceId, ITaskInstanceExecutionEvent.TaskInstanceExecutionEventType.RUNNING);
            } else {
                log.warn("TaskInstanceExecutionRunningEventAck failed: {}", (Object)taskInstanceExecutionRunningEventAck);
            }
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
        }
    }
}

