/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.operator;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceDispatchRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceDispatchResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorFactoryBuilder;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorThreadPool;
import org.apache.dolphinscheduler.server.worker.runner.operator.ITaskInstanceOperationFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceDispatchOperationFunction
implements ITaskInstanceOperationFunction<TaskInstanceDispatchRequest, TaskInstanceDispatchResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceDispatchOperationFunction.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private WorkerTaskExecutorFactoryBuilder workerTaskExecutorFactoryBuilder;
    @Autowired
    private WorkerTaskExecutorThreadPool workerTaskExecutorThreadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInstanceDispatchResponse operate(TaskInstanceDispatchRequest taskInstanceDispatchRequest) {
        log.info("Receive TaskInstanceDispatchRequest: {}", (Object)taskInstanceDispatchRequest);
        TaskExecutionContext taskExecutionContext = taskInstanceDispatchRequest.getTaskExecutionContext();
        try {
            taskExecutionContext.setHost(this.workerConfig.getWorkerAddress());
            taskExecutionContext.setLogPath(LogUtils.getTaskInstanceLogFullPath((TaskExecutionContext)taskExecutionContext));
            LogUtils.setWorkflowAndTaskInstanceIDMDC((Integer)taskExecutionContext.getProcessInstanceId(), (Integer)taskExecutionContext.getTaskInstanceId());
            if (!ServerLifeCycleManager.isRunning()) {
                log.error("server is not running. reject task: {}", (Object)taskExecutionContext.getProcessInstanceId());
                TaskInstanceDispatchResponse taskInstanceDispatchResponse = TaskInstanceDispatchResponse.failed((Integer)taskExecutionContext.getTaskInstanceId(), (String)"server is not running");
                return taskInstanceDispatchResponse;
            }
            TaskMetrics.incrTaskTypeExecuteCount(taskExecutionContext.getTaskType());
            WorkerTaskExecutor workerTaskExecutor = this.workerTaskExecutorFactoryBuilder.createWorkerTaskExecutorFactory(taskExecutionContext).createWorkerTaskExecutor();
            if (!this.workerTaskExecutorThreadPool.submitWorkerTaskExecutor(workerTaskExecutor)) {
                log.info("Submit task: {} to wait queue failed", (Object)taskExecutionContext.getTaskName());
                TaskInstanceDispatchResponse taskInstanceDispatchResponse = TaskInstanceDispatchResponse.failed((Integer)taskExecutionContext.getTaskInstanceId(), (String)"WorkerManagerThread is full");
                return taskInstanceDispatchResponse;
            }
            log.info("Submit task: {} to wait queue success", (Object)taskExecutionContext.getTaskName());
            TaskInstanceDispatchResponse taskInstanceDispatchResponse = TaskInstanceDispatchResponse.success((Integer)taskExecutionContext.getTaskInstanceId());
            return taskInstanceDispatchResponse;
        }
        finally {
            LogUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

