/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.operator;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.TaskInstanceKillResponse;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorThreadPool;
import org.apache.dolphinscheduler.server.worker.runner.operator.ITaskInstanceOperationFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceKillOperationFunction
implements ITaskInstanceOperationFunction<TaskInstanceKillRequest, TaskInstanceKillResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceKillOperationFunction.class);
    @Autowired
    private WorkerTaskExecutorThreadPool workerManager;
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInstanceKillResponse operate(TaskInstanceKillRequest taskInstanceKillRequest) {
        log.info("Receive TaskInstanceKillRequest: {}", (Object)taskInstanceKillRequest);
        int taskInstanceId = taskInstanceKillRequest.getTaskInstanceId();
        try {
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            WorkerTaskExecutor workerTaskExecutor = WorkerTaskExecutorHolder.get(taskInstanceId);
            if (workerTaskExecutor == null) {
                log.error("Cannot find WorkerTaskExecutor for taskInstance: {}", (Object)taskInstanceId);
                TaskInstanceKillResponse taskInstanceKillResponse = TaskInstanceKillResponse.fail((String)"Cannot find WorkerTaskExecutor");
                return taskInstanceKillResponse;
            }
            TaskExecutionContext taskExecutionContext = workerTaskExecutor.getTaskExecutionContext();
            LogUtils.setTaskInstanceLogFullPathMDC((String)taskExecutionContext.getLogPath());
            boolean result = this.doKill(taskExecutionContext);
            this.cancelApplication(workerTaskExecutor);
            int processId = taskExecutionContext.getProcessId();
            if (processId == 0) {
                this.workerManager.killTaskBeforeExecuteByInstanceId(taskInstanceId);
                taskExecutionContext.setCurrentExecutionStatus(TaskExecutionStatus.KILL);
                WorkerTaskExecutorHolder.remove(taskInstanceId);
                log.info("The task has not been executed and has been cancelled, task id:{}", (Object)taskInstanceId);
                TaskInstanceKillResponse taskInstanceKillResponse = TaskInstanceKillResponse.success((TaskExecutionContext)taskExecutionContext);
                return taskInstanceKillResponse;
            }
            taskExecutionContext.setCurrentExecutionStatus(result ? TaskExecutionStatus.SUCCESS : TaskExecutionStatus.FAILURE);
            WorkerTaskExecutorHolder.remove(taskExecutionContext.getTaskInstanceId());
            this.messageRetryRunner.removeRetryMessages(taskExecutionContext.getTaskInstanceId());
            TaskInstanceKillResponse taskInstanceKillResponse = TaskInstanceKillResponse.success((TaskExecutionContext)taskExecutionContext);
            return taskInstanceKillResponse;
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
            LogUtils.removeTaskInstanceLogFullPathMDC();
        }
    }

    private boolean doKill(TaskExecutionContext taskExecutionContext) {
        boolean processFlag = this.killProcess(taskExecutionContext.getTenantCode(), taskExecutionContext.getProcessId());
        try {
            ProcessUtils.cancelApplication((TaskExecutionContext)taskExecutionContext);
        }
        catch (TaskException e) {
            return false;
        }
        return processFlag;
    }

    protected void cancelApplication(WorkerTaskExecutor workerTaskExecutor) {
        AbstractTask task = workerTaskExecutor.getTask();
        if (task == null) {
            log.warn("task not found, taskInstanceId: {}", (Object)workerTaskExecutor.getTaskExecutionContext().getTaskInstanceId());
            return;
        }
        try {
            task.cancel();
        }
        catch (Exception e) {
            log.error("kill task error", (Throwable)e);
        }
        log.info("kill task by cancelApplication, taskInstanceId: {}", (Object)workerTaskExecutor.getTaskExecutionContext().getTaskInstanceId());
    }

    protected boolean killProcess(String tenantCode, Integer processId) {
        boolean processFlag = true;
        if (processId == null || processId.equals(0)) {
            return true;
        }
        try {
            String pidsStr = ProcessUtils.getPidsStr((int)processId);
            if (!Strings.isNullOrEmpty((String)pidsStr)) {
                String cmd = String.format("kill -9 %s", pidsStr);
                cmd = OSUtils.getSudoCmd((String)tenantCode, (String)cmd);
                log.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
                OSUtils.exeCmd((String)cmd);
            }
        }
        catch (Exception e) {
            processFlag = false;
            log.error("kill task error", (Throwable)e);
        }
        return processFlag;
    }
}

