/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner.operator;

import lombok.Generated;
import org.apache.dolphinscheduler.extract.worker.transportor.UpdateWorkflowHostRequest;
import org.apache.dolphinscheduler.extract.worker.transportor.UpdateWorkflowHostResponse;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.message.MessageRetryRunner;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutor;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorHolder;
import org.apache.dolphinscheduler.server.worker.runner.operator.ITaskInstanceOperationFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateWorkflowHostOperationFunction
implements ITaskInstanceOperationFunction<UpdateWorkflowHostRequest, UpdateWorkflowHostResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateWorkflowHostOperationFunction.class);
    @Autowired
    private MessageRetryRunner messageRetryRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkflowHostResponse operate(UpdateWorkflowHostRequest updateWorkflowHostRequest) {
        try {
            int taskInstanceId = updateWorkflowHostRequest.getTaskInstanceId();
            String workflowHost = updateWorkflowHostRequest.getWorkflowHost();
            LogUtils.setTaskInstanceIdMDC((Integer)taskInstanceId);
            log.info("Received UpdateWorkflowHostRequest: {}", (Object)updateWorkflowHostRequest);
            boolean updateWorkerTaskExecutor = this.updateHostInWorkflowTaskExecutor(taskInstanceId, workflowHost);
            boolean updateMessage = this.updateHostInMessage(taskInstanceId, workflowHost);
            if (updateWorkerTaskExecutor || updateMessage) {
                UpdateWorkflowHostResponse updateWorkflowHostResponse = UpdateWorkflowHostResponse.success();
                return updateWorkflowHostResponse;
            }
            UpdateWorkflowHostResponse updateWorkflowHostResponse = UpdateWorkflowHostResponse.failed((String)"The taskInstance is not in the worker");
            return updateWorkflowHostResponse;
        }
        finally {
            LogUtils.removeTaskInstanceIdMDC();
            LogUtils.removeTaskInstanceLogFullPathMDC();
        }
    }

    private boolean updateHostInWorkflowTaskExecutor(int taskInstanceId, String workflowHost) {
        WorkerTaskExecutor workerTaskExecutor = WorkerTaskExecutorHolder.get(taskInstanceId);
        if (workerTaskExecutor == null) {
            return false;
        }
        TaskExecutionContext taskExecutionContext = workerTaskExecutor.getTaskExecutionContext();
        taskExecutionContext.setWorkflowInstanceHost(workflowHost);
        return true;
    }

    private boolean updateHostInMessage(int taskInstanceId, String workflowHost) {
        return this.messageRetryRunner.updateMessageHost(taskInstanceId, workflowHost);
    }
}

