/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerServerLoadProtection;
import org.apache.dolphinscheduler.server.worker.runner.WorkerTaskExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerHeartBeatTask
extends BaseHeartBeatTask<WorkerHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerHeartBeatTask.class);
    private final WorkerConfig workerConfig;
    private final RegistryClient registryClient;
    private final MetricsProvider metricsProvider;
    private final WorkerTaskExecutorThreadPool workerTaskExecutorThreadPool;
    private final int processId;

    public WorkerHeartBeatTask(@NonNull WorkerConfig workerConfig, @NonNull MetricsProvider metricsProvider, @NonNull RegistryClient registryClient, @NonNull WorkerTaskExecutorThreadPool workerTaskExecutorThreadPool) {
        super("WorkerHeartBeatTask", workerConfig.getMaxHeartbeatInterval().toMillis());
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (metricsProvider == null) {
            throw new NullPointerException("metricsProvider is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (workerTaskExecutorThreadPool == null) {
            throw new NullPointerException("workerTaskExecutorThreadPool is marked non-null but is null");
        }
        this.metricsProvider = metricsProvider;
        this.workerConfig = workerConfig;
        this.registryClient = registryClient;
        this.workerTaskExecutorThreadPool = workerTaskExecutorThreadPool;
        this.processId = OSUtils.getProcessID();
    }

    public WorkerHeartBeat getHeartBeat() {
        SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
        ServerStatus serverStatus = this.getServerStatus(systemMetrics, this.workerConfig, this.workerTaskExecutorThreadPool);
        return WorkerHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime()).reportTime(System.currentTimeMillis()).cpuUsage(systemMetrics.getTotalCpuUsedPercentage()).jvmMemoryUsage(systemMetrics.getJvmMemoryUsedPercentage()).memoryUsage(systemMetrics.getSystemMemoryUsedPercentage()).diskUsage(systemMetrics.getDiskUsedPercentage()).processId(this.processId).workerHostWeight(this.workerConfig.getHostWeight()).threadPoolUsage(this.workerTaskExecutorThreadPool.getRunningTaskExecutorSize() + this.workerTaskExecutorThreadPool.getWaitingTaskExecutorSize()).serverStatus(serverStatus).host(NetUtils.getHost()).port(this.workerConfig.getListenPort()).build();
    }

    public void writeHeartBeat(WorkerHeartBeat workerHeartBeat) {
        String workerHeartBeatJson = JSONUtils.toJsonString((Object)workerHeartBeat);
        String workerRegistryPath = this.workerConfig.getWorkerRegistryPath();
        this.registryClient.persistEphemeral(workerRegistryPath, workerHeartBeatJson);
        log.debug("Success write worker group heartBeatInfo into registry, workerRegistryPath: {} workerHeartBeatInfo: {}", (Object)workerRegistryPath, (Object)workerHeartBeatJson);
    }

    private ServerStatus getServerStatus(SystemMetrics systemMetrics, WorkerConfig workerConfig, WorkerTaskExecutorThreadPool workerTaskExecutorThreadPool) {
        if (workerTaskExecutorThreadPool.isOverload()) {
            return ServerStatus.BUSY;
        }
        WorkerServerLoadProtection serverLoadProtection = workerConfig.getServerLoadProtection();
        return serverLoadProtection.isOverload(systemMetrics) ? ServerStatus.BUSY : ServerStatus.NORMAL;
    }
}

