/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.constants.TenantConstants;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.server.worker.config.TenantConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContextUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextUtils.class);

    public static String getOrCreateTenant(WorkerConfig workerConfig, TaskExecutionContext taskExecutionContext) {
        try {
            boolean osUserExistFlag;
            TenantConfig tenantConfig = workerConfig.getTenantConfig();
            String tenantCode = taskExecutionContext.getTenantCode();
            if ("default".equals(tenantCode) && tenantConfig.isDefaultTenantEnabled()) {
                log.info("Current tenant is default tenant, will use bootstrap user: {} to execute the task", (Object)TenantConstants.BOOTSTRAPT_SYSTEM_USER);
                return TenantConstants.BOOTSTRAPT_SYSTEM_USER;
            }
            if (tenantConfig.isDistributedTenantEnabled() && SystemUtils.IS_OS_LINUX) {
                osUserExistFlag = OSUtils.existTenantCodeInLinux((String)tenantCode);
            } else if (OSUtils.isSudoEnable() && tenantConfig.isAutoCreateTenantEnabled()) {
                OSUtils.createUserIfAbsent((String)tenantCode);
                osUserExistFlag = OSUtils.getUserList().contains(tenantCode);
            } else {
                osUserExistFlag = OSUtils.getUserList().contains(tenantCode);
            }
            if (!osUserExistFlag) {
                throw new TaskException(String.format("TenantCode: %s doesn't exist", tenantCode));
            }
            return tenantCode;
        }
        catch (TaskException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TaskException(String.format("TenantCode: %s doesn't exist", taskExecutionContext.getTenantCode()));
        }
    }

    public static void createTaskInstanceWorkingDirectory(TaskExecutionContext taskExecutionContext) throws TaskException {
        String taskInstanceWorkingDirectory = FileUtils.getTaskInstanceWorkingDirectory((String)taskExecutionContext.getTenantCode(), (long)taskExecutionContext.getProjectCode(), (long)taskExecutionContext.getProcessDefineCode(), (int)taskExecutionContext.getProcessDefineVersion(), (int)taskExecutionContext.getProcessInstanceId(), (int)taskExecutionContext.getTaskInstanceId());
        try {
            if (new File(taskInstanceWorkingDirectory).exists()) {
                FileUtils.deleteFile((String)taskInstanceWorkingDirectory);
                log.warn("The TaskInstance WorkingDirectory: {} is exist, will recreate again", (Object)taskInstanceWorkingDirectory);
            }
            FileUtils.createDirectoryWith755((Path)Paths.get(taskInstanceWorkingDirectory, new String[0]));
            taskExecutionContext.setExecutePath(taskInstanceWorkingDirectory);
            taskExecutionContext.setAppInfoPath(FileUtils.getAppInfoPath((String)taskInstanceWorkingDirectory));
        }
        catch (Throwable ex) {
            throw new TaskException("Cannot create TaskInstance WorkingDirectory: " + taskInstanceWorkingDirectory + " failed", ex);
        }
    }

    public static ResourceContext downloadResourcesIfNeeded(String tenant, TaskChannel taskChannel, StorageOperate storageOperate, TaskExecutionContext taskExecutionContext) {
        AbstractParameters abstractParameters = taskChannel.parseParameters(ParametersNode.builder().taskType(taskExecutionContext.getTaskType()).taskParams(taskExecutionContext.getTaskParams()).build());
        List resourceFilesList = abstractParameters.getResourceFilesList();
        if (CollectionUtils.isEmpty((Collection)resourceFilesList)) {
            log.debug("There is no resource file need to download");
            return new ResourceContext();
        }
        ResourceContext resourceContext = new ResourceContext();
        String taskWorkingDirectory = taskExecutionContext.getExecutePath();
        for (ResourceInfo resourceInfo : resourceFilesList) {
            String resourceAbsolutePathInStorage = resourceInfo.getResourceName();
            String resourceRelativePath = storageOperate.getResourceFileName(tenant, resourceAbsolutePathInStorage);
            String resourceAbsolutePathInLocal = Paths.get(taskWorkingDirectory, resourceRelativePath).toString();
            File file = new File(resourceAbsolutePathInLocal);
            if (!file.exists()) {
                try {
                    long resourceDownloadStartTime = System.currentTimeMillis();
                    storageOperate.download(resourceAbsolutePathInStorage, resourceAbsolutePathInLocal, true);
                    log.debug("Download resource file {} under: {} successfully", (Object)resourceAbsolutePathInStorage, (Object)resourceAbsolutePathInLocal);
                    FileUtils.setFileTo755((File)file);
                    WorkerServerMetrics.recordWorkerResourceDownloadTime(System.currentTimeMillis() - resourceDownloadStartTime);
                    WorkerServerMetrics.recordWorkerResourceDownloadSize(Files.size(Paths.get(resourceAbsolutePathInLocal, new String[0])));
                    WorkerServerMetrics.incWorkerResourceDownloadSuccessCount();
                }
                catch (Exception ex) {
                    WorkerServerMetrics.incWorkerResourceDownloadFailureCount();
                    throw new TaskException(String.format("Download resource file: %s error", resourceAbsolutePathInStorage), (Throwable)ex);
                }
            }
            ResourceContext.ResourceItem resourceItem = ResourceContext.ResourceItem.builder().resourceAbsolutePathInStorage(resourceAbsolutePathInStorage).resourceRelativePath(resourceRelativePath).resourceAbsolutePathInLocal(resourceAbsolutePathInLocal).build();
            resourceContext.addResourceItem(resourceItem);
        }
        return resourceContext;
    }
}

