/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.sdk.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TScanOpenParams
implements TBase<TScanOpenParams, _Fields>,
Serializable,
Cloneable,
Comparable<TScanOpenParams> {
    private static final TStruct STRUCT_DESC = new TStruct("TScanOpenParams");
    private static final TField CLUSTER_FIELD_DESC = new TField("cluster", 11, 1);
    private static final TField DATABASE_FIELD_DESC = new TField("database", 11, 2);
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 3);
    private static final TField TABLET_IDS_FIELD_DESC = new TField("tablet_ids", 15, 4);
    private static final TField OPAQUED_QUERY_PLAN_FIELD_DESC = new TField("opaqued_query_plan", 11, 5);
    private static final TField BATCH_SIZE_FIELD_DESC = new TField("batch_size", 8, 6);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 7);
    private static final TField LIMIT_FIELD_DESC = new TField("limit", 10, 8);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 9);
    private static final TField PASSWD_FIELD_DESC = new TField("passwd", 11, 10);
    private static final TField KEEP_ALIVE_MIN_FIELD_DESC = new TField("keep_alive_min", 6, 11);
    private static final TField QUERY_TIMEOUT_FIELD_DESC = new TField("query_timeout", 8, 12);
    private static final TField MEM_LIMIT_FIELD_DESC = new TField("mem_limit", 10, 13);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TScanOpenParamsStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TScanOpenParamsTupleSchemeFactory();
    @Nullable
    public String cluster;
    @Nullable
    public String database;
    @Nullable
    public String table;
    @Nullable
    public List<Long> tablet_ids;
    @Nullable
    public String opaqued_query_plan;
    public int batch_size;
    @Nullable
    public Map<String, String> properties;
    public long limit;
    @Nullable
    public String user;
    @Nullable
    public String passwd;
    public short keep_alive_min;
    public int query_timeout;
    public long mem_limit;
    private static final int __BATCH_SIZE_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private static final int __KEEP_ALIVE_MIN_ISSET_ID = 2;
    private static final int __QUERY_TIMEOUT_ISSET_ID = 3;
    private static final int __MEM_LIMIT_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.BATCH_SIZE, _Fields.PROPERTIES, _Fields.LIMIT, _Fields.USER, _Fields.PASSWD, _Fields.KEEP_ALIVE_MIN, _Fields.QUERY_TIMEOUT, _Fields.MEM_LIMIT};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TScanOpenParams() {
    }

    public TScanOpenParams(String cluster, String database, String table, List<Long> tablet_ids, String opaqued_query_plan) {
        this();
        this.cluster = cluster;
        this.database = database;
        this.table = table;
        this.tablet_ids = tablet_ids;
        this.opaqued_query_plan = opaqued_query_plan;
    }

    public TScanOpenParams(TScanOpenParams other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetCluster()) {
            this.cluster = other.cluster;
        }
        if (other.isSetDatabase()) {
            this.database = other.database;
        }
        if (other.isSetTable()) {
            this.table = other.table;
        }
        if (other.isSetTabletIds()) {
            ArrayList<Long> __this__tablet_ids = new ArrayList<Long>(other.tablet_ids);
            this.tablet_ids = __this__tablet_ids;
        }
        if (other.isSetOpaquedQueryPlan()) {
            this.opaqued_query_plan = other.opaqued_query_plan;
        }
        this.batch_size = other.batch_size;
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>(other.properties);
            this.properties = __this__properties;
        }
        this.limit = other.limit;
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetPasswd()) {
            this.passwd = other.passwd;
        }
        this.keep_alive_min = other.keep_alive_min;
        this.query_timeout = other.query_timeout;
        this.mem_limit = other.mem_limit;
    }

    public TScanOpenParams deepCopy() {
        return new TScanOpenParams(this);
    }

    public void clear() {
        this.cluster = null;
        this.database = null;
        this.table = null;
        this.tablet_ids = null;
        this.opaqued_query_plan = null;
        this.setBatchSizeIsSet(false);
        this.batch_size = 0;
        this.properties = null;
        this.setLimitIsSet(false);
        this.limit = 0L;
        this.user = null;
        this.passwd = null;
        this.setKeepAliveMinIsSet(false);
        this.keep_alive_min = 0;
        this.setQueryTimeoutIsSet(false);
        this.query_timeout = 0;
        this.setMemLimitIsSet(false);
        this.mem_limit = 0L;
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    public TScanOpenParams setCluster(@Nullable String cluster) {
        this.cluster = cluster;
        return this;
    }

    public void unsetCluster() {
        this.cluster = null;
    }

    public boolean isSetCluster() {
        return this.cluster != null;
    }

    public void setClusterIsSet(boolean value) {
        if (!value) {
            this.cluster = null;
        }
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    public TScanOpenParams setDatabase(@Nullable String database) {
        this.database = database;
        return this;
    }

    public void unsetDatabase() {
        this.database = null;
    }

    public boolean isSetDatabase() {
        return this.database != null;
    }

    public void setDatabaseIsSet(boolean value) {
        if (!value) {
            this.database = null;
        }
    }

    @Nullable
    public String getTable() {
        return this.table;
    }

    public TScanOpenParams setTable(@Nullable String table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public int getTabletIdsSize() {
        return this.tablet_ids == null ? 0 : this.tablet_ids.size();
    }

    @Nullable
    public Iterator<Long> getTabletIdsIterator() {
        return this.tablet_ids == null ? null : this.tablet_ids.iterator();
    }

    public void addToTabletIds(long elem) {
        if (this.tablet_ids == null) {
            this.tablet_ids = new ArrayList<Long>();
        }
        this.tablet_ids.add(elem);
    }

    @Nullable
    public List<Long> getTabletIds() {
        return this.tablet_ids;
    }

    public TScanOpenParams setTabletIds(@Nullable List<Long> tablet_ids) {
        this.tablet_ids = tablet_ids;
        return this;
    }

    public void unsetTabletIds() {
        this.tablet_ids = null;
    }

    public boolean isSetTabletIds() {
        return this.tablet_ids != null;
    }

    public void setTabletIdsIsSet(boolean value) {
        if (!value) {
            this.tablet_ids = null;
        }
    }

    @Nullable
    public String getOpaquedQueryPlan() {
        return this.opaqued_query_plan;
    }

    public TScanOpenParams setOpaquedQueryPlan(@Nullable String opaqued_query_plan) {
        this.opaqued_query_plan = opaqued_query_plan;
        return this;
    }

    public void unsetOpaquedQueryPlan() {
        this.opaqued_query_plan = null;
    }

    public boolean isSetOpaquedQueryPlan() {
        return this.opaqued_query_plan != null;
    }

    public void setOpaquedQueryPlanIsSet(boolean value) {
        if (!value) {
            this.opaqued_query_plan = null;
        }
    }

    public int getBatchSize() {
        return this.batch_size;
    }

    public TScanOpenParams setBatchSize(int batch_size) {
        this.batch_size = batch_size;
        this.setBatchSizeIsSet(true);
        return this;
    }

    public void unsetBatchSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetBatchSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setBatchSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TScanOpenParams setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public TScanOpenParams setLimit(long limit) {
        this.limit = limit;
        this.setLimitIsSet(true);
        return this;
    }

    public void unsetLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLimit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public TScanOpenParams setUser(@Nullable String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    @Nullable
    public String getPasswd() {
        return this.passwd;
    }

    public TScanOpenParams setPasswd(@Nullable String passwd) {
        this.passwd = passwd;
        return this;
    }

    public void unsetPasswd() {
        this.passwd = null;
    }

    public boolean isSetPasswd() {
        return this.passwd != null;
    }

    public void setPasswdIsSet(boolean value) {
        if (!value) {
            this.passwd = null;
        }
    }

    public short getKeepAliveMin() {
        return this.keep_alive_min;
    }

    public TScanOpenParams setKeepAliveMin(short keep_alive_min) {
        this.keep_alive_min = keep_alive_min;
        this.setKeepAliveMinIsSet(true);
        return this;
    }

    public void unsetKeepAliveMin() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetKeepAliveMin() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setKeepAliveMinIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getQueryTimeout() {
        return this.query_timeout;
    }

    public TScanOpenParams setQueryTimeout(int query_timeout) {
        this.query_timeout = query_timeout;
        this.setQueryTimeoutIsSet(true);
        return this;
    }

    public void unsetQueryTimeout() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetQueryTimeout() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setQueryTimeoutIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getMemLimit() {
        return this.mem_limit;
    }

    public TScanOpenParams setMemLimit(long mem_limit) {
        this.mem_limit = mem_limit;
        this.setMemLimitIsSet(true);
        return this;
    }

    public void unsetMemLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetMemLimit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setMemLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case CLUSTER: {
                if (value == null) {
                    this.unsetCluster();
                    break;
                }
                this.setCluster((String)value);
                break;
            }
            case DATABASE: {
                if (value == null) {
                    this.unsetDatabase();
                    break;
                }
                this.setDatabase((String)value);
                break;
            }
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((String)value);
                break;
            }
            case TABLET_IDS: {
                if (value == null) {
                    this.unsetTabletIds();
                    break;
                }
                this.setTabletIds((List)value);
                break;
            }
            case OPAQUED_QUERY_PLAN: {
                if (value == null) {
                    this.unsetOpaquedQueryPlan();
                    break;
                }
                this.setOpaquedQueryPlan((String)value);
                break;
            }
            case BATCH_SIZE: {
                if (value == null) {
                    this.unsetBatchSize();
                    break;
                }
                this.setBatchSize((Integer)value);
                break;
            }
            case PROPERTIES: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
                break;
            }
            case LIMIT: {
                if (value == null) {
                    this.unsetLimit();
                    break;
                }
                this.setLimit((Long)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case PASSWD: {
                if (value == null) {
                    this.unsetPasswd();
                    break;
                }
                this.setPasswd((String)value);
                break;
            }
            case KEEP_ALIVE_MIN: {
                if (value == null) {
                    this.unsetKeepAliveMin();
                    break;
                }
                this.setKeepAliveMin((Short)value);
                break;
            }
            case QUERY_TIMEOUT: {
                if (value == null) {
                    this.unsetQueryTimeout();
                    break;
                }
                this.setQueryTimeout((Integer)value);
                break;
            }
            case MEM_LIMIT: {
                if (value == null) {
                    this.unsetMemLimit();
                    break;
                }
                this.setMemLimit((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CLUSTER: {
                return this.getCluster();
            }
            case DATABASE: {
                return this.getDatabase();
            }
            case TABLE: {
                return this.getTable();
            }
            case TABLET_IDS: {
                return this.getTabletIds();
            }
            case OPAQUED_QUERY_PLAN: {
                return this.getOpaquedQueryPlan();
            }
            case BATCH_SIZE: {
                return this.getBatchSize();
            }
            case PROPERTIES: {
                return this.getProperties();
            }
            case LIMIT: {
                return this.getLimit();
            }
            case USER: {
                return this.getUser();
            }
            case PASSWD: {
                return this.getPasswd();
            }
            case KEEP_ALIVE_MIN: {
                return this.getKeepAliveMin();
            }
            case QUERY_TIMEOUT: {
                return this.getQueryTimeout();
            }
            case MEM_LIMIT: {
                return this.getMemLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CLUSTER: {
                return this.isSetCluster();
            }
            case DATABASE: {
                return this.isSetDatabase();
            }
            case TABLE: {
                return this.isSetTable();
            }
            case TABLET_IDS: {
                return this.isSetTabletIds();
            }
            case OPAQUED_QUERY_PLAN: {
                return this.isSetOpaquedQueryPlan();
            }
            case BATCH_SIZE: {
                return this.isSetBatchSize();
            }
            case PROPERTIES: {
                return this.isSetProperties();
            }
            case LIMIT: {
                return this.isSetLimit();
            }
            case USER: {
                return this.isSetUser();
            }
            case PASSWD: {
                return this.isSetPasswd();
            }
            case KEEP_ALIVE_MIN: {
                return this.isSetKeepAliveMin();
            }
            case QUERY_TIMEOUT: {
                return this.isSetQueryTimeout();
            }
            case MEM_LIMIT: {
                return this.isSetMemLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TScanOpenParams) {
            return this.equals((TScanOpenParams)that);
        }
        return false;
    }

    public boolean equals(TScanOpenParams that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_cluster = this.isSetCluster();
        boolean that_present_cluster = that.isSetCluster();
        if (this_present_cluster || that_present_cluster) {
            if (!this_present_cluster || !that_present_cluster) {
                return false;
            }
            if (!this.cluster.equals(that.cluster)) {
                return false;
            }
        }
        boolean this_present_database = this.isSetDatabase();
        boolean that_present_database = that.isSetDatabase();
        if (this_present_database || that_present_database) {
            if (!this_present_database || !that_present_database) {
                return false;
            }
            if (!this.database.equals(that.database)) {
                return false;
            }
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_tablet_ids = this.isSetTabletIds();
        boolean that_present_tablet_ids = that.isSetTabletIds();
        if (this_present_tablet_ids || that_present_tablet_ids) {
            if (!this_present_tablet_ids || !that_present_tablet_ids) {
                return false;
            }
            if (!this.tablet_ids.equals(that.tablet_ids)) {
                return false;
            }
        }
        boolean this_present_opaqued_query_plan = this.isSetOpaquedQueryPlan();
        boolean that_present_opaqued_query_plan = that.isSetOpaquedQueryPlan();
        if (this_present_opaqued_query_plan || that_present_opaqued_query_plan) {
            if (!this_present_opaqued_query_plan || !that_present_opaqued_query_plan) {
                return false;
            }
            if (!this.opaqued_query_plan.equals(that.opaqued_query_plan)) {
                return false;
            }
        }
        boolean this_present_batch_size = this.isSetBatchSize();
        boolean that_present_batch_size = that.isSetBatchSize();
        if (this_present_batch_size || that_present_batch_size) {
            if (!this_present_batch_size || !that_present_batch_size) {
                return false;
            }
            if (this.batch_size != that.batch_size) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        boolean this_present_limit = this.isSetLimit();
        boolean that_present_limit = that.isSetLimit();
        if (this_present_limit || that_present_limit) {
            if (!this_present_limit || !that_present_limit) {
                return false;
            }
            if (this.limit != that.limit) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_passwd = this.isSetPasswd();
        boolean that_present_passwd = that.isSetPasswd();
        if (this_present_passwd || that_present_passwd) {
            if (!this_present_passwd || !that_present_passwd) {
                return false;
            }
            if (!this.passwd.equals(that.passwd)) {
                return false;
            }
        }
        boolean this_present_keep_alive_min = this.isSetKeepAliveMin();
        boolean that_present_keep_alive_min = that.isSetKeepAliveMin();
        if (this_present_keep_alive_min || that_present_keep_alive_min) {
            if (!this_present_keep_alive_min || !that_present_keep_alive_min) {
                return false;
            }
            if (this.keep_alive_min != that.keep_alive_min) {
                return false;
            }
        }
        boolean this_present_query_timeout = this.isSetQueryTimeout();
        boolean that_present_query_timeout = that.isSetQueryTimeout();
        if (this_present_query_timeout || that_present_query_timeout) {
            if (!this_present_query_timeout || !that_present_query_timeout) {
                return false;
            }
            if (this.query_timeout != that.query_timeout) {
                return false;
            }
        }
        boolean this_present_mem_limit = this.isSetMemLimit();
        boolean that_present_mem_limit = that.isSetMemLimit();
        if (this_present_mem_limit || that_present_mem_limit) {
            if (!this_present_mem_limit || !that_present_mem_limit) {
                return false;
            }
            if (this.mem_limit != that.mem_limit) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetCluster() ? 131071 : 524287);
        if (this.isSetCluster()) {
            hashCode = hashCode * 8191 + this.cluster.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDatabase() ? 131071 : 524287);
        if (this.isSetDatabase()) {
            hashCode = hashCode * 8191 + this.database.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTable() ? 131071 : 524287);
        if (this.isSetTable()) {
            hashCode = hashCode * 8191 + this.table.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTabletIds() ? 131071 : 524287);
        if (this.isSetTabletIds()) {
            hashCode = hashCode * 8191 + this.tablet_ids.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOpaquedQueryPlan() ? 131071 : 524287);
        if (this.isSetOpaquedQueryPlan()) {
            hashCode = hashCode * 8191 + this.opaqued_query_plan.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBatchSize() ? 131071 : 524287);
        if (this.isSetBatchSize()) {
            hashCode = hashCode * 8191 + this.batch_size;
        }
        hashCode = hashCode * 8191 + (this.isSetProperties() ? 131071 : 524287);
        if (this.isSetProperties()) {
            hashCode = hashCode * 8191 + this.properties.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLimit() ? 131071 : 524287);
        if (this.isSetLimit()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.limit);
        }
        hashCode = hashCode * 8191 + (this.isSetUser() ? 131071 : 524287);
        if (this.isSetUser()) {
            hashCode = hashCode * 8191 + this.user.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPasswd() ? 131071 : 524287);
        if (this.isSetPasswd()) {
            hashCode = hashCode * 8191 + this.passwd.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetKeepAliveMin() ? 131071 : 524287);
        if (this.isSetKeepAliveMin()) {
            hashCode = hashCode * 8191 + this.keep_alive_min;
        }
        hashCode = hashCode * 8191 + (this.isSetQueryTimeout() ? 131071 : 524287);
        if (this.isSetQueryTimeout()) {
            hashCode = hashCode * 8191 + this.query_timeout;
        }
        hashCode = hashCode * 8191 + (this.isSetMemLimit() ? 131071 : 524287);
        if (this.isSetMemLimit()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.mem_limit);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TScanOpenParams other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetCluster(), other.isSetCluster());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCluster() && (lastComparison = TBaseHelper.compareTo((String)this.cluster, (String)other.cluster)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDatabase(), other.isSetDatabase());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDatabase() && (lastComparison = TBaseHelper.compareTo((String)this.database, (String)other.database)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTable(), other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((String)this.table, (String)other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTabletIds(), other.isSetTabletIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletIds() && (lastComparison = TBaseHelper.compareTo(this.tablet_ids, other.tablet_ids)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOpaquedQueryPlan(), other.isSetOpaquedQueryPlan());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOpaquedQueryPlan() && (lastComparison = TBaseHelper.compareTo((String)this.opaqued_query_plan, (String)other.opaqued_query_plan)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBatchSize(), other.isSetBatchSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBatchSize() && (lastComparison = TBaseHelper.compareTo((int)this.batch_size, (int)other.batch_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProperties(), other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo(this.properties, other.properties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLimit(), other.isSetLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLimit() && (lastComparison = TBaseHelper.compareTo((long)this.limit, (long)other.limit)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetUser(), other.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)other.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPasswd(), other.isSetPasswd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPasswd() && (lastComparison = TBaseHelper.compareTo((String)this.passwd, (String)other.passwd)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKeepAliveMin(), other.isSetKeepAliveMin());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeepAliveMin() && (lastComparison = TBaseHelper.compareTo((short)this.keep_alive_min, (short)other.keep_alive_min)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQueryTimeout(), other.isSetQueryTimeout());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryTimeout() && (lastComparison = TBaseHelper.compareTo((int)this.query_timeout, (int)other.query_timeout)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMemLimit(), other.isSetMemLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMemLimit() && (lastComparison = TBaseHelper.compareTo((long)this.mem_limit, (long)other.mem_limit)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TScanOpenParams.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TScanOpenParams.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TScanOpenParams(");
        boolean first = true;
        sb.append("cluster:");
        if (this.cluster == null) {
            sb.append("null");
        } else {
            sb.append(this.cluster);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("database:");
        if (this.database == null) {
            sb.append("null");
        } else {
            sb.append(this.database);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("table:");
        if (this.table == null) {
            sb.append("null");
        } else {
            sb.append(this.table);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tablet_ids:");
        if (this.tablet_ids == null) {
            sb.append("null");
        } else {
            sb.append(this.tablet_ids);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("opaqued_query_plan:");
        if (this.opaqued_query_plan == null) {
            sb.append("null");
        } else {
            sb.append(this.opaqued_query_plan);
        }
        first = false;
        if (this.isSetBatchSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("batch_size:");
            sb.append(this.batch_size);
            first = false;
        }
        if (this.isSetProperties()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("properties:");
            if (this.properties == null) {
                sb.append("null");
            } else {
                sb.append(this.properties);
            }
            first = false;
        }
        if (this.isSetLimit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("limit:");
            sb.append(this.limit);
            first = false;
        }
        if (this.isSetUser()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("user:");
            if (this.user == null) {
                sb.append("null");
            } else {
                sb.append(this.user);
            }
            first = false;
        }
        if (this.isSetPasswd()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("passwd:");
            if (this.passwd == null) {
                sb.append("null");
            } else {
                sb.append(this.passwd);
            }
            first = false;
        }
        if (this.isSetKeepAliveMin()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("keep_alive_min:");
            sb.append(this.keep_alive_min);
            first = false;
        }
        if (this.isSetQueryTimeout()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("query_timeout:");
            sb.append(this.query_timeout);
            first = false;
        }
        if (this.isSetMemLimit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("mem_limit:");
            sb.append(this.mem_limit);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.cluster == null) {
            throw new TProtocolException("Required field 'cluster' was not present! Struct: " + this.toString());
        }
        if (this.database == null) {
            throw new TProtocolException("Required field 'database' was not present! Struct: " + this.toString());
        }
        if (this.table == null) {
            throw new TProtocolException("Required field 'table' was not present! Struct: " + this.toString());
        }
        if (this.tablet_ids == null) {
            throw new TProtocolException("Required field 'tablet_ids' was not present! Struct: " + this.toString());
        }
        if (this.opaqued_query_plan == null) {
            throw new TProtocolException("Required field 'opaqued_query_plan' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CLUSTER, new FieldMetaData("cluster", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DATABASE, new FieldMetaData("database", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLET_IDS, new FieldMetaData("tablet_ids", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(10))));
        tmpMap.put(_Fields.OPAQUED_QUERY_PLAN, new FieldMetaData("opaqued_query_plan", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BATCH_SIZE, new FieldMetaData("batch_size", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.LIMIT, new FieldMetaData("limit", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PASSWD, new FieldMetaData("passwd", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.KEEP_ALIVE_MIN, new FieldMetaData("keep_alive_min", 2, new FieldValueMetaData(6)));
        tmpMap.put(_Fields.QUERY_TIMEOUT, new FieldMetaData("query_timeout", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MEM_LIMIT, new FieldMetaData("mem_limit", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TScanOpenParams.class, metaDataMap);
    }

    private static class TScanOpenParamsTupleScheme
    extends TupleScheme<TScanOpenParams> {
        private TScanOpenParamsTupleScheme() {
        }

        public void write(TProtocol prot, TScanOpenParams struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.cluster);
            oprot.writeString(struct.database);
            oprot.writeString(struct.table);
            oprot.writeI32(struct.tablet_ids.size());
            for (long _iter9 : struct.tablet_ids) {
                oprot.writeI64(_iter9);
            }
            oprot.writeString(struct.opaqued_query_plan);
            BitSet optionals = new BitSet();
            if (struct.isSetBatchSize()) {
                optionals.set(0);
            }
            if (struct.isSetProperties()) {
                optionals.set(1);
            }
            if (struct.isSetLimit()) {
                optionals.set(2);
            }
            if (struct.isSetUser()) {
                optionals.set(3);
            }
            if (struct.isSetPasswd()) {
                optionals.set(4);
            }
            if (struct.isSetKeepAliveMin()) {
                optionals.set(5);
            }
            if (struct.isSetQueryTimeout()) {
                optionals.set(6);
            }
            if (struct.isSetMemLimit()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetBatchSize()) {
                oprot.writeI32(struct.batch_size);
            }
            if (struct.isSetProperties()) {
                oprot.writeI32(struct.properties.size());
                for (Map.Entry<String, String> _iter10 : struct.properties.entrySet()) {
                    oprot.writeString(_iter10.getKey());
                    oprot.writeString(_iter10.getValue());
                }
            }
            if (struct.isSetLimit()) {
                oprot.writeI64(struct.limit);
            }
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetPasswd()) {
                oprot.writeString(struct.passwd);
            }
            if (struct.isSetKeepAliveMin()) {
                oprot.writeI16(struct.keep_alive_min);
            }
            if (struct.isSetQueryTimeout()) {
                oprot.writeI32(struct.query_timeout);
            }
            if (struct.isSetMemLimit()) {
                oprot.writeI64(struct.mem_limit);
            }
        }

        public void read(TProtocol prot, TScanOpenParams struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.cluster = iprot.readString();
            struct.setClusterIsSet(true);
            struct.database = iprot.readString();
            struct.setDatabaseIsSet(true);
            struct.table = iprot.readString();
            struct.setTableIsSet(true);
            TList _list11 = iprot.readListBegin((byte)10);
            struct.tablet_ids = new ArrayList<Long>(_list11.size);
            for (int _i13 = 0; _i13 < _list11.size; ++_i13) {
                long _elem12 = iprot.readI64();
                struct.tablet_ids.add(_elem12);
            }
            struct.setTabletIdsIsSet(true);
            struct.opaqued_query_plan = iprot.readString();
            struct.setOpaquedQueryPlanIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.batch_size = iprot.readI32();
                struct.setBatchSizeIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map14 = iprot.readMapBegin((byte)11, (byte)11);
                struct.properties = new HashMap<String, String>(2 * _map14.size);
                for (int _i17 = 0; _i17 < _map14.size; ++_i17) {
                    String _key15 = iprot.readString();
                    String _val16 = iprot.readString();
                    struct.properties.put(_key15, _val16);
                }
                struct.setPropertiesIsSet(true);
            }
            if (incoming.get(2)) {
                struct.limit = iprot.readI64();
                struct.setLimitIsSet(true);
            }
            if (incoming.get(3)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(4)) {
                struct.passwd = iprot.readString();
                struct.setPasswdIsSet(true);
            }
            if (incoming.get(5)) {
                struct.keep_alive_min = iprot.readI16();
                struct.setKeepAliveMinIsSet(true);
            }
            if (incoming.get(6)) {
                struct.query_timeout = iprot.readI32();
                struct.setQueryTimeoutIsSet(true);
            }
            if (incoming.get(7)) {
                struct.mem_limit = iprot.readI64();
                struct.setMemLimitIsSet(true);
            }
        }
    }

    private static class TScanOpenParamsTupleSchemeFactory
    implements SchemeFactory {
        private TScanOpenParamsTupleSchemeFactory() {
        }

        public TScanOpenParamsTupleScheme getScheme() {
            return new TScanOpenParamsTupleScheme();
        }
    }

    private static class TScanOpenParamsStandardScheme
    extends StandardScheme<TScanOpenParams> {
        private TScanOpenParamsStandardScheme() {
        }

        public void read(TProtocol iprot, TScanOpenParams struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.cluster = iprot.readString();
                            struct.setClusterIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.database = iprot.readString();
                            struct.setDatabaseIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readString();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.tablet_ids = new ArrayList<Long>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                long _elem1 = iprot.readI64();
                                struct.tablet_ids.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setTabletIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.opaqued_query_plan = iprot.readString();
                            struct.setOpaquedQueryPlanIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.batch_size = iprot.readI32();
                            struct.setBatchSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 13) {
                            TMap _map3 = iprot.readMapBegin();
                            struct.properties = new HashMap<String, String>(2 * _map3.size);
                            for (int _i6 = 0; _i6 < _map3.size; ++_i6) {
                                String _key4 = iprot.readString();
                                String _val5 = iprot.readString();
                                struct.properties.put(_key4, _val5);
                            }
                            iprot.readMapEnd();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.limit = iprot.readI64();
                            struct.setLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.passwd = iprot.readString();
                            struct.setPasswdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 6) {
                            struct.keep_alive_min = iprot.readI16();
                            struct.setKeepAliveMinIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 8) {
                            struct.query_timeout = iprot.readI32();
                            struct.setQueryTimeoutIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 10) {
                            struct.mem_limit = iprot.readI64();
                            struct.setMemLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TScanOpenParams struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.cluster != null) {
                oprot.writeFieldBegin(CLUSTER_FIELD_DESC);
                oprot.writeString(struct.cluster);
                oprot.writeFieldEnd();
            }
            if (struct.database != null) {
                oprot.writeFieldBegin(DATABASE_FIELD_DESC);
                oprot.writeString(struct.database);
                oprot.writeFieldEnd();
            }
            if (struct.table != null) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeString(struct.table);
                oprot.writeFieldEnd();
            }
            if (struct.tablet_ids != null) {
                oprot.writeFieldBegin(TABLET_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.tablet_ids.size()));
                Iterator<Object> iterator = struct.tablet_ids.iterator();
                while (iterator.hasNext()) {
                    long l = iterator.next();
                    oprot.writeI64(l);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.opaqued_query_plan != null) {
                oprot.writeFieldBegin(OPAQUED_QUERY_PLAN_FIELD_DESC);
                oprot.writeString(struct.opaqued_query_plan);
                oprot.writeFieldEnd();
            }
            if (struct.isSetBatchSize()) {
                oprot.writeFieldBegin(BATCH_SIZE_FIELD_DESC);
                oprot.writeI32(struct.batch_size);
                oprot.writeFieldEnd();
            }
            if (struct.properties != null && struct.isSetProperties()) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.properties.size()));
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetLimit()) {
                oprot.writeFieldBegin(LIMIT_FIELD_DESC);
                oprot.writeI64(struct.limit);
                oprot.writeFieldEnd();
            }
            if (struct.user != null && struct.isSetUser()) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.passwd != null && struct.isSetPasswd()) {
                oprot.writeFieldBegin(PASSWD_FIELD_DESC);
                oprot.writeString(struct.passwd);
                oprot.writeFieldEnd();
            }
            if (struct.isSetKeepAliveMin()) {
                oprot.writeFieldBegin(KEEP_ALIVE_MIN_FIELD_DESC);
                oprot.writeI16(struct.keep_alive_min);
                oprot.writeFieldEnd();
            }
            if (struct.isSetQueryTimeout()) {
                oprot.writeFieldBegin(QUERY_TIMEOUT_FIELD_DESC);
                oprot.writeI32(struct.query_timeout);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMemLimit()) {
                oprot.writeFieldBegin(MEM_LIMIT_FIELD_DESC);
                oprot.writeI64(struct.mem_limit);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TScanOpenParamsStandardSchemeFactory
    implements SchemeFactory {
        private TScanOpenParamsStandardSchemeFactory() {
        }

        public TScanOpenParamsStandardScheme getScheme() {
            return new TScanOpenParamsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CLUSTER(1, "cluster"),
        DATABASE(2, "database"),
        TABLE(3, "table"),
        TABLET_IDS(4, "tablet_ids"),
        OPAQUED_QUERY_PLAN(5, "opaqued_query_plan"),
        BATCH_SIZE(6, "batch_size"),
        PROPERTIES(7, "properties"),
        LIMIT(8, "limit"),
        USER(9, "user"),
        PASSWD(10, "passwd"),
        KEEP_ALIVE_MIN(11, "keep_alive_min"),
        QUERY_TIMEOUT(12, "query_timeout"),
        MEM_LIMIT(13, "mem_limit");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CLUSTER;
                }
                case 2: {
                    return DATABASE;
                }
                case 3: {
                    return TABLE;
                }
                case 4: {
                    return TABLET_IDS;
                }
                case 5: {
                    return OPAQUED_QUERY_PLAN;
                }
                case 6: {
                    return BATCH_SIZE;
                }
                case 7: {
                    return PROPERTIES;
                }
                case 8: {
                    return LIMIT;
                }
                case 9: {
                    return USER;
                }
                case 10: {
                    return PASSWD;
                }
                case 11: {
                    return KEEP_ALIVE_MIN;
                }
                case 12: {
                    return QUERY_TIMEOUT;
                }
                case 13: {
                    return MEM_LIMIT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

