/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.sdk.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.sdk.thrift.TScalarType;
import org.apache.doris.sdk.thrift.TStructField;
import org.apache.doris.sdk.thrift.TTypeNodeType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTypeNode
implements TBase<TTypeNode, _Fields>,
Serializable,
Cloneable,
Comparable<TTypeNode> {
    private static final TStruct STRUCT_DESC = new TStruct("TTypeNode");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField SCALAR_TYPE_FIELD_DESC = new TField("scalar_type", 12, 2);
    private static final TField STRUCT_FIELDS_FIELD_DESC = new TField("struct_fields", 15, 3);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TTypeNodeStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TTypeNodeTupleSchemeFactory();
    @Nullable
    public TTypeNodeType type;
    @Nullable
    public TScalarType scalar_type;
    @Nullable
    public List<TStructField> struct_fields;
    private static final _Fields[] optionals = new _Fields[]{_Fields.SCALAR_TYPE, _Fields.STRUCT_FIELDS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TTypeNode() {
    }

    public TTypeNode(TTypeNodeType type) {
        this();
        this.type = type;
    }

    public TTypeNode(TTypeNode other) {
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetScalarType()) {
            this.scalar_type = new TScalarType(other.scalar_type);
        }
        if (other.isSetStructFields()) {
            ArrayList<TStructField> __this__struct_fields = new ArrayList<TStructField>(other.struct_fields.size());
            for (TStructField other_element : other.struct_fields) {
                __this__struct_fields.add(new TStructField(other_element));
            }
            this.struct_fields = __this__struct_fields;
        }
    }

    public TTypeNode deepCopy() {
        return new TTypeNode(this);
    }

    public void clear() {
        this.type = null;
        this.scalar_type = null;
        this.struct_fields = null;
    }

    @Nullable
    public TTypeNodeType getType() {
        return this.type;
    }

    public TTypeNode setType(@Nullable TTypeNodeType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    @Nullable
    public TScalarType getScalarType() {
        return this.scalar_type;
    }

    public TTypeNode setScalarType(@Nullable TScalarType scalar_type) {
        this.scalar_type = scalar_type;
        return this;
    }

    public void unsetScalarType() {
        this.scalar_type = null;
    }

    public boolean isSetScalarType() {
        return this.scalar_type != null;
    }

    public void setScalarTypeIsSet(boolean value) {
        if (!value) {
            this.scalar_type = null;
        }
    }

    public int getStructFieldsSize() {
        return this.struct_fields == null ? 0 : this.struct_fields.size();
    }

    @Nullable
    public Iterator<TStructField> getStructFieldsIterator() {
        return this.struct_fields == null ? null : this.struct_fields.iterator();
    }

    public void addToStructFields(TStructField elem) {
        if (this.struct_fields == null) {
            this.struct_fields = new ArrayList<TStructField>();
        }
        this.struct_fields.add(elem);
    }

    @Nullable
    public List<TStructField> getStructFields() {
        return this.struct_fields;
    }

    public TTypeNode setStructFields(@Nullable List<TStructField> struct_fields) {
        this.struct_fields = struct_fields;
        return this;
    }

    public void unsetStructFields() {
        this.struct_fields = null;
    }

    public boolean isSetStructFields() {
        return this.struct_fields != null;
    }

    public void setStructFieldsIsSet(boolean value) {
        if (!value) {
            this.struct_fields = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((TTypeNodeType)((Object)value));
                break;
            }
            case SCALAR_TYPE: {
                if (value == null) {
                    this.unsetScalarType();
                    break;
                }
                this.setScalarType((TScalarType)value);
                break;
            }
            case STRUCT_FIELDS: {
                if (value == null) {
                    this.unsetStructFields();
                    break;
                }
                this.setStructFields((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case SCALAR_TYPE: {
                return this.getScalarType();
            }
            case STRUCT_FIELDS: {
                return this.getStructFields();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case SCALAR_TYPE: {
                return this.isSetScalarType();
            }
            case STRUCT_FIELDS: {
                return this.isSetStructFields();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TTypeNode) {
            return this.equals((TTypeNode)that);
        }
        return false;
    }

    public boolean equals(TTypeNode that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_scalar_type = this.isSetScalarType();
        boolean that_present_scalar_type = that.isSetScalarType();
        if (this_present_scalar_type || that_present_scalar_type) {
            if (!this_present_scalar_type || !that_present_scalar_type) {
                return false;
            }
            if (!this.scalar_type.equals(that.scalar_type)) {
                return false;
            }
        }
        boolean this_present_struct_fields = this.isSetStructFields();
        boolean that_present_struct_fields = that.isSetStructFields();
        if (this_present_struct_fields || that_present_struct_fields) {
            if (!this_present_struct_fields || !that_present_struct_fields) {
                return false;
            }
            if (!this.struct_fields.equals(that.struct_fields)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetScalarType() ? 131071 : 524287);
        if (this.isSetScalarType()) {
            hashCode = hashCode * 8191 + this.scalar_type.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStructFields() ? 131071 : 524287);
        if (this.isSetStructFields()) {
            hashCode = hashCode * 8191 + this.struct_fields.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TTypeNode other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetScalarType(), other.isSetScalarType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScalarType() && (lastComparison = TBaseHelper.compareTo((Comparable)this.scalar_type, (Comparable)other.scalar_type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStructFields(), other.isSetStructFields());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStructFields() && (lastComparison = TBaseHelper.compareTo(this.struct_fields, other.struct_fields)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TTypeNode.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TTypeNode.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TTypeNode(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetScalarType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("scalar_type:");
            if (this.scalar_type == null) {
                sb.append("null");
            } else {
                sb.append(this.scalar_type);
            }
            first = false;
        }
        if (this.isSetStructFields()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("struct_fields:");
            if (this.struct_fields == null) {
                sb.append("null");
            } else {
                sb.append(this.struct_fields);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.scalar_type != null) {
            this.scalar_type.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, TTypeNodeType.class)));
        tmpMap.put(_Fields.SCALAR_TYPE, new FieldMetaData("scalar_type", 2, (FieldValueMetaData)new StructMetaData(12, TScalarType.class)));
        tmpMap.put(_Fields.STRUCT_FIELDS, new FieldMetaData("struct_fields", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TStructField.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TTypeNode.class, metaDataMap);
    }

    private static class TTypeNodeTupleScheme
    extends TupleScheme<TTypeNode> {
        private TTypeNodeTupleScheme() {
        }

        public void write(TProtocol prot, TTypeNode struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetScalarType()) {
                optionals.set(0);
            }
            if (struct.isSetStructFields()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetScalarType()) {
                struct.scalar_type.write((TProtocol)oprot);
            }
            if (struct.isSetStructFields()) {
                oprot.writeI32(struct.struct_fields.size());
                for (TStructField _iter4 : struct.struct_fields) {
                    _iter4.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TTypeNode struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = TTypeNodeType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.scalar_type = new TScalarType();
                struct.scalar_type.read((TProtocol)iprot);
                struct.setScalarTypeIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list5 = iprot.readListBegin((byte)12);
                struct.struct_fields = new ArrayList<TStructField>(_list5.size);
                for (int _i7 = 0; _i7 < _list5.size; ++_i7) {
                    TStructField _elem6 = new TStructField();
                    _elem6.read((TProtocol)iprot);
                    struct.struct_fields.add(_elem6);
                }
                struct.setStructFieldsIsSet(true);
            }
        }
    }

    private static class TTypeNodeTupleSchemeFactory
    implements SchemeFactory {
        private TTypeNodeTupleSchemeFactory() {
        }

        public TTypeNodeTupleScheme getScheme() {
            return new TTypeNodeTupleScheme();
        }
    }

    private static class TTypeNodeStandardScheme
    extends StandardScheme<TTypeNode> {
        private TTypeNodeStandardScheme() {
        }

        public void read(TProtocol iprot, TTypeNode struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.type = TTypeNodeType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.scalar_type = new TScalarType();
                            struct.scalar_type.read(iprot);
                            struct.setScalarTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.struct_fields = new ArrayList<TStructField>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                TStructField _elem1 = new TStructField();
                                _elem1.read(iprot);
                                struct.struct_fields.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setStructFieldsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TTypeNode struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.scalar_type != null && struct.isSetScalarType()) {
                oprot.writeFieldBegin(SCALAR_TYPE_FIELD_DESC);
                struct.scalar_type.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.struct_fields != null && struct.isSetStructFields()) {
                oprot.writeFieldBegin(STRUCT_FIELDS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.struct_fields.size()));
                for (TStructField _iter3 : struct.struct_fields) {
                    _iter3.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TTypeNodeStandardSchemeFactory
    implements SchemeFactory {
        private TTypeNodeStandardSchemeFactory() {
        }

        public TTypeNodeStandardScheme getScheme() {
            return new TTypeNodeStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        SCALAR_TYPE(2, "scalar_type"),
        STRUCT_FIELDS(3, "struct_fields");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return SCALAR_TYPE;
                }
                case 3: {
                    return STRUCT_FIELDS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

