/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.utils.Runnables;

public class SqlFirehose
implements Firehose {
    private final Iterator<JsonIterator<Map<String, Object>>> resultIterator;
    private final InputRowParser parser;
    private final Closeable closer;
    private JsonIterator<Map<String, Object>> lineIterator = null;

    public SqlFirehose(Iterator lineIterators, InputRowParser<Map<String, Object>> parser, Closeable closer) {
        this.resultIterator = lineIterators;
        this.parser = parser;
        this.closer = closer;
    }

    @Override
    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.resultIterator.hasNext()) {
            this.lineIterator = this.getNextLineIterator();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    @Nullable
    public InputRow nextRow() {
        Map<String, Object> mapToParse = this.lineIterator.next();
        return (InputRow)Iterators.getOnlyElement(this.parser.parseBatch(mapToParse).iterator());
    }

    private JsonIterator getNextLineIterator() {
        if (this.lineIterator != null) {
            this.lineIterator = null;
        }
        JsonIterator<Map<String, Object>> iterator = this.resultIterator.next();
        return iterator;
    }

    @Override
    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    @Override
    public void close() throws IOException {
        Closer firehoseCloser = Closer.create();
        if (this.lineIterator != null) {
            firehoseCloser.register(this.lineIterator);
        }
        firehoseCloser.register(this.closer);
        firehoseCloser.close();
    }
}

