/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import java.util.concurrent.TimeUnit;

public class PrefetchConfig {
    public static final long DEFAULT_MAX_CACHE_CAPACITY_BYTES = 0x40000000L;
    public static final long DEFAULT_MAX_FETCH_CAPACITY_BYTES = 0x40000000L;
    public static final long DEFAULT_FETCH_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(60L);
    private final long maxFetchCapacityBytes;
    private final long maxCacheCapacityBytes;
    private final long prefetchTriggerBytes;
    private final long fetchTimeout;

    public PrefetchConfig(Long maxCacheCapacityBytes, Long maxFetchCapacityBytes, Long prefetchTriggerBytes, Long fetchTimeout) {
        this.maxCacheCapacityBytes = maxCacheCapacityBytes == null ? 0x40000000L : maxCacheCapacityBytes;
        this.maxFetchCapacityBytes = maxFetchCapacityBytes == null ? 0x40000000L : maxFetchCapacityBytes;
        this.prefetchTriggerBytes = prefetchTriggerBytes == null ? this.maxFetchCapacityBytes / 2L : prefetchTriggerBytes;
        this.fetchTimeout = fetchTimeout == null ? DEFAULT_FETCH_TIMEOUT_MS : fetchTimeout;
    }

    public long getMaxCacheCapacityBytes() {
        return this.maxCacheCapacityBytes;
    }

    public long getMaxFetchCapacityBytes() {
        return this.maxFetchCapacityBytes;
    }

    public long getPrefetchTriggerBytes() {
        return this.prefetchTriggerBytes;
    }

    public long getFetchTimeout() {
        return this.fetchTimeout;
    }
}

