/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public interface DataSegmentFinder {
    public static final Logger log = new Logger(DataSegmentFinder.class);

    public Set<DataSegment> findSegments(String var1, boolean var2) throws SegmentLoadingException;

    public static void putInMapRetainingNewest(Map<String, Pair<DataSegment, Long>> timestampedSegments, DataSegment dataSegment, long segmentModifiedAt) {
        timestampedSegments.merge(dataSegment.getIdentifier(), (Pair<DataSegment, Long>)Pair.of((Object)dataSegment, (Object)segmentModifiedAt), (previous, current) -> {
            log.warn("Multiple copies of segmentId [%s] found, using newest version", new Object[]{((DataSegment)current.lhs).getIdentifier()});
            return (Long)previous.rhs > (Long)current.rhs ? previous : current;
        });
    }
}

