/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tasklogs;

import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.tasklogs.TaskLogs;

public class NoopTaskLogs
implements TaskLogs {
    private final Logger log = new Logger(TaskLogs.class);

    @Override
    public Optional<ByteSource> streamTaskLog(String taskid, long offset) {
        return Optional.absent();
    }

    @Override
    public void pushTaskLog(String taskid, File logFile) {
        this.log.info("Not pushing logs for task: %s", new Object[]{taskid});
    }

    @Override
    public void pushTaskReports(String taskid, File reportFile) throws IOException {
        this.log.info("Not pushing reports for task: %s", new Object[]{taskid});
    }

    @Override
    public void killAll() {
        this.log.info("Noop: No task logs are deleted.", new Object[0]);
    }

    @Override
    public void killOlderThan(long timestamp) {
        this.log.info("Noop: No task logs are deleted.", new Object[0]);
    }
}

