/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.druid.indexer.DetermineHashedPartitionsJob;
import org.apache.druid.indexer.DeterminePartitionsJob;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HadoopDruidDetermineConfigurationJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidDetermineConfigurationJob.class);
    private final HadoopDruidIndexerConfig config;
    private Jobby job;
    private String hadoopJobIdFile;

    @Inject
    public HadoopDruidDetermineConfigurationJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        HashPartitionFunction partitionFunction;
        int shardsPerInterval;
        JobHelper.ensurePaths(this.config);
        if (this.config.isDeterminingPartitions()) {
            this.job = HadoopDruidDetermineConfigurationJob.createPartitionJob(this.config);
            this.config.setHadoopJobIdFileName(this.hadoopJobIdFile);
            return JobHelper.runSingleJob(this.job, this.config);
        }
        DimensionBasedPartitionsSpec partitionsSpec = this.config.getPartitionsSpec();
        if (partitionsSpec instanceof HashedPartitionsSpec) {
            HashedPartitionsSpec hashedPartitionsSpec = (HashedPartitionsSpec)partitionsSpec;
            shardsPerInterval = PartitionsSpec.isEffectivelyNull((Integer)hashedPartitionsSpec.getNumShards()) ? 1 : hashedPartitionsSpec.getNumShards();
            partitionFunction = hashedPartitionsSpec.getPartitionFunction();
        } else {
            shardsPerInterval = 1;
            partitionFunction = null;
        }
        TreeMap<Long, List<HadoopyShardSpec>> shardSpecs = new TreeMap<Long, List<HadoopyShardSpec>>();
        int shardCount = 0;
        for (Interval segmentGranularity : (Set)this.config.getSegmentGranularIntervals().get()) {
            DateTime bucket = segmentGranularity.getStart();
            ArrayList specs = Lists.newArrayListWithCapacity((int)shardsPerInterval);
            for (int i = 0; i < shardsPerInterval; ++i) {
                specs.add(new HadoopyShardSpec((ShardSpec)new HashBasedNumberedShardSpec(i, shardsPerInterval, Integer.valueOf(i), Integer.valueOf(shardsPerInterval), this.config.getPartitionsSpec().getPartitionDimensions(), partitionFunction, HadoopDruidIndexerConfig.JSON_MAPPER), shardCount++));
            }
            shardSpecs.put(bucket.getMillis(), specs);
            log.info("DateTime[%s], spec[%s]", new Object[]{bucket, specs});
        }
        this.config.setShardSpecs(shardSpecs);
        return true;
    }

    private static Jobby createPartitionJob(HadoopDruidIndexerConfig config) {
        DimensionBasedPartitionsSpec partitionsSpec = config.getPartitionsSpec();
        if (partitionsSpec instanceof HashedPartitionsSpec) {
            return new DetermineHashedPartitionsJob(config);
        }
        if (partitionsSpec instanceof SingleDimensionPartitionsSpec) {
            return new DeterminePartitionsJob(config);
        }
        throw new ISE("Unknown partitionsSpec[%s]", new Object[]{partitionsSpec});
    }

    public Map<String, Object> getStats() {
        if (this.job == null) {
            return null;
        }
        return this.job.getStats();
    }

    public String getErrorMessage() {
        if (this.job == null) {
            return null;
        }
        return this.job.getErrorMessage();
    }

    public void setHadoopJobIdFile(String hadoopJobIdFile) {
        this.hadoopJobIdFile = hadoopJobIdFile;
    }
}

