/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexer.Bucket;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.HadoopKerberosConfig;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.IndexingHadoopModule;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.path.PathSpec;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.server.DruidNode;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class HadoopDruidIndexerConfig {
    private static final Injector INJECTOR;
    static final String CONFIG_PROPERTY = "druid.indexer.config";
    static final Charset JAVA_NATIVE_CHARSET;
    static final Splitter TAB_SPLITTER;
    static final Joiner TAB_JOINER;
    public static final ObjectMapper JSON_MAPPER;
    public static final IndexIO INDEX_IO;
    static final IndexMerger INDEX_MERGER_V9;
    static final HadoopKerberosConfig HADOOP_KERBEROS_CONFIG;
    static final DataSegmentPusher DATA_SEGMENT_PUSHER;
    private static final String DEFAULT_WORKING_PATH = "/tmp/druid-indexing";
    public static final Properties PROPERTIES;
    private HadoopIngestionSpec schema;
    private PathSpec pathSpec;
    private String hadoopJobIdFileName;
    private final Map<Long, ShardSpecLookup> shardSpecLookups = new HashMap<Long, ShardSpecLookup>();
    private final Map<Long, Map<ShardSpec, HadoopyShardSpec>> hadoopShardSpecLookup = new HashMap<Long, Map<ShardSpec, HadoopyShardSpec>>();
    private final Granularity rollupGran;
    private final List<String> allowedHadoopPrefix;

    public static HadoopDruidIndexerConfig fromSpec(HadoopIngestionSpec spec) {
        return new HadoopDruidIndexerConfig(spec);
    }

    private static HadoopDruidIndexerConfig fromMap(Map<String, Object> argSpec) {
        if (argSpec.containsKey("spec")) {
            return (HadoopDruidIndexerConfig)JSON_MAPPER.convertValue(argSpec, HadoopDruidIndexerConfig.class);
        }
        return new HadoopDruidIndexerConfig((HadoopIngestionSpec)((Object)JSON_MAPPER.convertValue(argSpec, HadoopIngestionSpec.class)));
    }

    public static HadoopDruidIndexerConfig fromFile(File file) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue(file, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopDruidIndexerConfig fromString(String str) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue(str, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopDruidIndexerConfig fromDistributedFileSystem(String path) {
        try {
            Path pt = new Path(path);
            FileSystem fs = pt.getFileSystem(new Configuration());
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(pt), StandardCharsets.UTF_8);
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue((Reader)reader, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopDruidIndexerConfig fromConfiguration(Configuration conf) {
        HadoopDruidIndexerConfig retVal = HadoopDruidIndexerConfig.fromString(conf.get(CONFIG_PROPERTY));
        retVal.verify();
        return retVal;
    }

    @JsonCreator
    public HadoopDruidIndexerConfig(@JsonProperty(value="spec") HadoopIngestionSpec spec) {
        this.schema = spec;
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(spec.getIOConfig().getPathSpec(), PathSpec.class);
        for (Map.Entry<Long, List<HadoopyShardSpec>> entry : spec.getTuningConfig().getShardSpecs().entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            ShardSpec actualSpec = entry.getValue().get(0).getActualSpec();
            this.shardSpecLookups.put(entry.getKey(), actualSpec.getLookup(Lists.transform(entry.getValue(), HadoopyShardSpec::getActualSpec)));
            HashMap<ShardSpec, HadoopyShardSpec> innerHadoopShardSpecLookup = new HashMap<ShardSpec, HadoopyShardSpec>();
            for (HadoopyShardSpec hadoopyShardSpec : entry.getValue()) {
                innerHadoopShardSpecLookup.put(hadoopyShardSpec.getActualSpec(), hadoopyShardSpec);
            }
            this.hadoopShardSpecLookup.put(entry.getKey(), innerHadoopShardSpecLookup);
        }
        this.rollupGran = spec.getDataSchema().getGranularitySpec().getQueryGranularity();
        this.allowedHadoopPrefix = new ArrayList<String>();
        this.allowedHadoopPrefix.add("druid.storage");
        this.allowedHadoopPrefix.add("druid.javascript");
        this.allowedHadoopPrefix.addAll(DATA_SEGMENT_PUSHER.getAllowedPropertyPrefixesForHadoop());
        this.allowedHadoopPrefix.addAll(spec.getTuningConfig().getUserAllowedHadoopPrefix());
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSchema() {
        return this.schema;
    }

    @JsonIgnore
    public PathSpec getPathSpec() {
        return this.pathSpec;
    }

    public String getDataSource() {
        return this.schema.getDataSchema().getDataSource();
    }

    public GranularitySpec getGranularitySpec() {
        return this.schema.getDataSchema().getGranularitySpec();
    }

    public void setGranularitySpec(GranularitySpec granularitySpec) {
        this.schema = this.schema.withDataSchema(this.schema.getDataSchema().withGranularitySpec(granularitySpec));
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public DimensionBasedPartitionsSpec getPartitionsSpec() {
        return this.schema.getTuningConfig().getPartitionsSpec();
    }

    public IndexSpec getIndexSpec() {
        return this.schema.getTuningConfig().getIndexSpec();
    }

    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.schema.getTuningConfig().getIndexSpecForIntermediatePersists();
    }

    boolean isOverwriteFiles() {
        return this.schema.getTuningConfig().isOverwriteFiles();
    }

    public void setShardSpecs(Map<Long, List<HadoopyShardSpec>> shardSpecs) {
        this.schema = this.schema.withTuningConfig(this.schema.getTuningConfig().withShardSpecs(shardSpecs));
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public Optional<List<Interval>> getIntervals() {
        Optional setOptional = this.schema.getDataSchema().getGranularitySpec().bucketIntervals();
        if (setOptional.isPresent()) {
            return Optional.of((Object)JodaUtils.condenseIntervals((Iterable)((Iterable)setOptional.get())));
        }
        return Optional.absent();
    }

    boolean isDeterminingPartitions() {
        return this.schema.getTuningConfig().getPartitionsSpec().needsDeterminePartitions(true);
    }

    public int getTargetPartitionSize() {
        DimensionBasedPartitionsSpec spec = this.schema.getTuningConfig().getPartitionsSpec();
        if (spec.getTargetRowsPerSegment() != null) {
            return spec.getTargetRowsPerSegment();
        }
        Integer targetPartitionSize = spec.getMaxRowsPerSegment();
        return targetPartitionSize == null ? -1 : targetPartitionSize;
    }

    boolean isForceExtendableShardSpecs() {
        return this.schema.getTuningConfig().isForceExtendableShardSpecs();
    }

    public boolean isUpdaterJobSpecSet() {
        return this.schema.getIOConfig().getMetadataUpdateSpec() != null;
    }

    public boolean isCombineText() {
        return this.schema.getTuningConfig().isCombineText();
    }

    public InputRowParser getParser() {
        return (InputRowParser)Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser(), (Object)"inputRowParser");
    }

    public HadoopyShardSpec getShardSpec(Bucket bucket) {
        return this.schema.getTuningConfig().getShardSpecs().get(bucket.time.getMillis()).get(bucket.partitionNum);
    }

    int getShardSpecCount(Bucket bucket) {
        return this.schema.getTuningConfig().getShardSpecs().get(bucket.time.getMillis()).size();
    }

    public boolean isLogParseExceptions() {
        return this.schema.getTuningConfig().isLogParseExceptions();
    }

    public int getMaxParseExceptions() {
        return this.schema.getTuningConfig().getMaxParseExceptions();
    }

    public Map<String, String> getAllowedProperties() {
        HashMap<String, String> allowedPropertiesMap = new HashMap<String, String>();
        block0: for (String propName : PROPERTIES.stringPropertyNames()) {
            for (String prefix : this.allowedHadoopPrefix) {
                if (!propName.equals(prefix) && !propName.startsWith(prefix + ".")) continue;
                allowedPropertiesMap.put(propName, PROPERTIES.getProperty(propName));
                continue block0;
            }
        }
        return allowedPropertiesMap;
    }

    boolean isUseYarnRMJobStatusFallback() {
        return this.schema.getTuningConfig().isUseYarnRMJobStatusFallback();
    }

    void setHadoopJobIdFileName(String hadoopJobIdFileName) {
        this.hadoopJobIdFileName = hadoopJobIdFileName;
    }

    String getHadoopJobIdFileName() {
        return this.hadoopJobIdFileName;
    }

    public Job addInputPaths(Job job) throws IOException {
        return this.pathSpec.addInputPaths(this, job);
    }

    Optional<Bucket> getBucket(InputRow inputRow) {
        Optional timeBucket = this.schema.getDataSchema().getGranularitySpec().bucketInterval(DateTimes.utc((long)inputRow.getTimestampFromEpoch()));
        if (!timeBucket.isPresent()) {
            return Optional.absent();
        }
        DateTime bucketStart = ((Interval)timeBucket.get()).getStart();
        ShardSpec actualSpec = this.shardSpecLookups.get(bucketStart.getMillis()).getShardSpec(this.rollupGran.bucketStart(inputRow.getTimestamp()).getMillis(), inputRow);
        HadoopyShardSpec hadoopyShardSpec = this.hadoopShardSpecLookup.get(bucketStart.getMillis()).get(actualSpec);
        return Optional.of((Object)new Bucket(hadoopyShardSpec.getShardNum(), bucketStart, actualSpec.getPartitionNum()));
    }

    Optional<Set<Interval>> getSegmentGranularIntervals() {
        return Optional.fromNullable((Object)this.schema.getDataSchema().getGranularitySpec().bucketIntervals().orNull());
    }

    public List<Interval> getInputIntervals() {
        return this.schema.getDataSchema().getGranularitySpec().inputIntervals();
    }

    Optional<Iterable<Bucket>> getAllBuckets() {
        Optional<Set<Interval>> intervals = this.getSegmentGranularIntervals();
        if (intervals.isPresent()) {
            return Optional.of((Object)FunctionalIterable.create((Iterable)((Iterable)intervals.get())).transformCat(input -> {
                final DateTime bucketTime = input.getStart();
                List<HadoopyShardSpec> specs = this.schema.getTuningConfig().getShardSpecs().get(bucketTime.getMillis());
                if (specs == null) {
                    return ImmutableList.of();
                }
                return FunctionalIterable.create(specs).transform((Function)new Function<HadoopyShardSpec, Bucket>(){
                    int i = 0;

                    public Bucket apply(HadoopyShardSpec input) {
                        return new Bucket(input.getShardNum(), bucketTime, this.i++);
                    }
                });
            }));
        }
        return Optional.absent();
    }

    public String getWorkingPath() {
        String workingPath = this.schema.getTuningConfig().getWorkingPath();
        return workingPath == null ? DEFAULT_WORKING_PATH : workingPath;
    }

    Path makeIntermediatePath() {
        return new Path(StringUtils.format((String)"%s/%s/%s_%s", (Object[])new Object[]{this.getWorkingPath(), this.schema.getDataSchema().getDataSource(), StringUtils.removeChar((String)this.schema.getTuningConfig().getVersion(), (char)':'), this.schema.getUniqueId()}));
    }

    Path makeSegmentPartitionInfoPath(Interval bucketInterval) {
        return new Path(StringUtils.format((String)"%s/%s_%s/partitions.json", (Object[])new Object[]{this.makeIntermediatePath(), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getStart()), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getEnd())}));
    }

    Path makeIntervalInfoPath() {
        return new Path(StringUtils.format((String)"%s/intervals.json", (Object[])new Object[]{this.makeIntermediatePath()}));
    }

    Path makeDescriptorInfoDir() {
        return new Path(this.makeIntermediatePath(), "segmentDescriptorInfo");
    }

    Path makeGroupedDataDir() {
        return new Path(this.makeIntermediatePath(), "groupedData");
    }

    Path makeDescriptorInfoPath(DataSegment segment) {
        return new Path(this.makeDescriptorInfoDir(), StringUtils.removeChar((String)(segment.getId() + ".json"), (char)':'));
    }

    void addJobProperties(Job job) {
        this.addJobProperties(job.getConfiguration());
    }

    void addJobProperties(Configuration conf) {
        for (Map.Entry<String, String> entry : this.schema.getTuningConfig().getJobProperties().entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    public void intoConfiguration(Job job) {
        Configuration conf = job.getConfiguration();
        try {
            conf.set(CONFIG_PROPERTY, JSON_MAPPER.writeValueAsString((Object)this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void verify() {
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getDataSource(), (Object)"dataSource");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser(), (Object)"inputRowParser");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser().getParseSpec(), (Object)"parseSpec");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getGranularitySpec(), (Object)"granularitySpec");
        Preconditions.checkNotNull((Object)this.pathSpec, (Object)"inputSpec");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getWorkingPath(), (Object)"workingPath");
        Preconditions.checkNotNull((Object)this.schema.getIOConfig().getSegmentOutputPath(), (Object)"segmentOutputPath");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getVersion(), (Object)"version");
    }

    static {
        JAVA_NATIVE_CHARSET = Charset.forName("Unicode");
        TAB_SPLITTER = Splitter.on((String)"\t");
        TAB_JOINER = Joiner.on((String)"\t");
        INJECTOR = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("hadoop-indexer", null, false, null, null, true, false));
            JsonConfigProvider.bind((Binder)binder, (String)"druid.hadoop.security.kerberos", HadoopKerberosConfig.class);
        }, (Object)new IndexingHadoopModule()));
        JSON_MAPPER = (ObjectMapper)INJECTOR.getInstance(ObjectMapper.class);
        INDEX_IO = (IndexIO)INJECTOR.getInstance(IndexIO.class);
        INDEX_MERGER_V9 = (IndexMerger)INJECTOR.getInstance(IndexMergerV9.class);
        HADOOP_KERBEROS_CONFIG = (HadoopKerberosConfig)INJECTOR.getInstance(HadoopKerberosConfig.class);
        DATA_SEGMENT_PUSHER = (DataSegmentPusher)INJECTOR.getInstance(DataSegmentPusher.class);
        PROPERTIES = (Properties)INJECTOR.getInstance(Properties.class);
    }

    public static enum IndexJobCounters {
        INVALID_ROW_COUNTER,
        ROWS_PROCESSED_COUNTER,
        ROWS_PROCESSED_WITH_ERRORS_COUNTER,
        ROWS_UNPARSEABLE_COUNTER,
        ROWS_THROWN_AWAY_COUNTER;

    }
}

