/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.hadoop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class WindowedDataSegment {
    private final DataSegment segment;
    private final Interval interval;

    @JsonCreator
    public WindowedDataSegment(@JsonProperty(value="segment") DataSegment segment, @JsonProperty(value="interval") Interval interval) {
        this.segment = segment;
        this.interval = interval;
    }

    @JsonProperty
    public DataSegment getSegment() {
        return this.segment;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedDataSegment that = (WindowedDataSegment)o;
        return Objects.equals(this.segment, that.segment) && Objects.equals(this.interval, that.interval);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.interval);
    }

    public String toString() {
        return "WindowedDataSegment{segment=" + this.segment + ", interval=" + this.interval + '}';
    }

    public static WindowedDataSegment of(DataSegment segment) {
        return new WindowedDataSegment(segment, segment.getInterval());
    }
}

