/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.CombiningIterable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopDruidIndexerMapper;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.SortableBytes;
import org.apache.druid.indexer.TaskMetricsUtils;
import org.apache.druid.indexer.Utils;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class DeterminePartitionsJob
implements Jobby {
    private static final Logger log = new Logger(DeterminePartitionsJob.class);
    private static final Joiner TAB_JOINER = HadoopDruidIndexerConfig.TAB_JOINER;
    private static final Splitter TAB_SPLITTER = HadoopDruidIndexerConfig.TAB_SPLITTER;
    private final HadoopDruidIndexerConfig config;
    private Job groupByJob;
    private String failureCause;

    DeterminePartitionsJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        try {
            Job dimSelectionJob;
            block20: {
                SingleDimensionPartitionsSpec partitionsSpec;
                block19: {
                    if (!(this.config.getPartitionsSpec() instanceof SingleDimensionPartitionsSpec)) {
                        throw new ISE("DeterminePartitionsJob can only be run for SingleDimensionPartitionsSpec, partitionSpec found [%s]", new Object[]{this.config.getPartitionsSpec()});
                    }
                    partitionsSpec = (SingleDimensionPartitionsSpec)this.config.getPartitionsSpec();
                    if (!partitionsSpec.isAssumeGrouped()) {
                        this.groupByJob = Job.getInstance((Configuration)new Configuration(), (String)StringUtils.format((String)"%s-determine_partitions_groupby-%s", (Object[])new Object[]{this.config.getDataSource(), this.config.getIntervals()}));
                        JobHelper.injectSystemProperties(this.groupByJob.getConfiguration(), this.config);
                        this.config.addJobProperties(this.groupByJob);
                        this.groupByJob.setMapperClass(DeterminePartitionsGroupByMapper.class);
                        this.groupByJob.setMapOutputKeyClass(BytesWritable.class);
                        this.groupByJob.setMapOutputValueClass(NullWritable.class);
                        this.groupByJob.setCombinerClass(DeterminePartitionsGroupByReducer.class);
                        this.groupByJob.setReducerClass(DeterminePartitionsGroupByReducer.class);
                        this.groupByJob.setOutputKeyClass(BytesWritable.class);
                        this.groupByJob.setOutputValueClass(NullWritable.class);
                        this.groupByJob.setOutputFormatClass(SequenceFileOutputFormat.class);
                        JobHelper.setupClasspath(JobHelper.distributedClassPath(this.config.getWorkingPath()), JobHelper.distributedClassPath(this.config.makeIntermediatePath()), this.groupByJob);
                        this.config.addInputPaths(this.groupByJob);
                        this.config.intoConfiguration(this.groupByJob);
                        FileOutputFormat.setOutputPath((Job)this.groupByJob, (Path)this.config.makeGroupedDataDir());
                        this.groupByJob.submit();
                        log.info("Job %s submitted, status available at: %s", new Object[]{this.groupByJob.getJobName(), this.groupByJob.getTrackingURL()});
                        if (this.groupByJob.getJobID() != null) {
                            JobHelper.writeJobIdToFile(this.config.getHadoopJobIdFileName(), this.groupByJob.getJobID().toString());
                        }
                        try {
                            if (!this.groupByJob.waitForCompletion(true)) {
                                log.error("Job failed: %s", new Object[]{this.groupByJob.getJobID()});
                                this.failureCause = Utils.getFailureMessage(this.groupByJob, HadoopDruidIndexerConfig.JSON_MAPPER);
                                return false;
                            }
                            break block19;
                        }
                        catch (IOException ioe) {
                            if (!Utils.checkAppSuccessForJobIOException(ioe, this.groupByJob, this.config.isUseYarnRMJobStatusFallback())) {
                                throw ioe;
                            }
                            break block19;
                        }
                    }
                    log.info("Skipping group-by job.", new Object[0]);
                }
                dimSelectionJob = Job.getInstance((Configuration)new Configuration(), (String)StringUtils.format((String)"%s-determine_partitions_dimselection-%s", (Object[])new Object[]{this.config.getDataSource(), this.config.getIntervals()}));
                dimSelectionJob.getConfiguration().set("io.sort.record.percent", "0.19");
                JobHelper.injectSystemProperties(dimSelectionJob.getConfiguration(), this.config);
                this.config.addJobProperties(dimSelectionJob);
                if (!partitionsSpec.isAssumeGrouped()) {
                    dimSelectionJob.setMapperClass(DeterminePartitionsDimSelectionPostGroupByMapper.class);
                    dimSelectionJob.setInputFormatClass(SequenceFileInputFormat.class);
                    FileInputFormat.addInputPath((Job)dimSelectionJob, (Path)this.config.makeGroupedDataDir());
                } else {
                    dimSelectionJob.setMapperClass(DeterminePartitionsDimSelectionAssumeGroupedMapper.class);
                    this.config.addInputPaths(dimSelectionJob);
                }
                SortableBytes.useSortableBytesAsMapOutputKey(dimSelectionJob, DeterminePartitionsDimSelectionPartitioner.class);
                dimSelectionJob.setMapOutputValueClass(Text.class);
                dimSelectionJob.setCombinerClass(DeterminePartitionsDimSelectionCombiner.class);
                dimSelectionJob.setReducerClass(DeterminePartitionsDimSelectionReducer.class);
                dimSelectionJob.setOutputKeyClass(BytesWritable.class);
                dimSelectionJob.setOutputValueClass(Text.class);
                dimSelectionJob.setOutputFormatClass(DeterminePartitionsDimSelectionOutputFormat.class);
                dimSelectionJob.setNumReduceTasks(Iterators.size(this.config.getGranularitySpec().sortedBucketIntervals().iterator()));
                JobHelper.setupClasspath(JobHelper.distributedClassPath(this.config.getWorkingPath()), JobHelper.distributedClassPath(this.config.makeIntermediatePath()), dimSelectionJob);
                this.config.intoConfiguration(dimSelectionJob);
                FileOutputFormat.setOutputPath((Job)dimSelectionJob, (Path)this.config.makeIntermediatePath());
                dimSelectionJob.submit();
                log.info("Job %s submitted, status available at: %s", new Object[]{dimSelectionJob.getJobName(), dimSelectionJob.getTrackingURL()});
                if (dimSelectionJob.getJobID() != null) {
                    JobHelper.writeJobIdToFile(this.config.getHadoopJobIdFileName(), dimSelectionJob.getJobID().toString());
                }
                try {
                    if (!dimSelectionJob.waitForCompletion(true)) {
                        log.error("Job failed: %s", new Object[]{dimSelectionJob.getJobID().toString()});
                        this.failureCause = Utils.getFailureMessage(dimSelectionJob, HadoopDruidIndexerConfig.JSON_MAPPER);
                        return false;
                    }
                }
                catch (IOException ioe) {
                    if (Utils.checkAppSuccessForJobIOException(ioe, dimSelectionJob, this.config.isUseYarnRMJobStatusFallback())) break block20;
                    throw ioe;
                }
            }
            log.info("Job completed, loading up partitions for intervals[%s].", new Object[]{this.config.getSegmentGranularIntervals()});
            FileSystem fileSystem = null;
            TreeMap<Long, List<HadoopyShardSpec>> shardSpecs = new TreeMap<Long, List<HadoopyShardSpec>>();
            int shardCount = 0;
            for (Interval segmentGranularity : this.config.getSegmentGranularIntervals()) {
                Path partitionInfoPath = this.config.makeSegmentPartitionInfoPath(segmentGranularity);
                if (fileSystem == null) {
                    fileSystem = partitionInfoPath.getFileSystem(dimSelectionJob.getConfiguration());
                }
                if (Utils.exists((JobContext)dimSelectionJob, fileSystem, partitionInfoPath)) {
                    List specs = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(Utils.openInputStream((JobContext)dimSelectionJob, partitionInfoPath), (TypeReference)new TypeReference<List<ShardSpec>>(){});
                    ArrayList actualSpecs = Lists.newArrayListWithExpectedSize((int)specs.size());
                    for (int i = 0; i < specs.size(); ++i) {
                        actualSpecs.add(new HadoopyShardSpec((ShardSpec)specs.get(i), shardCount++));
                        log.info("DateTime[%s], partition[%d], spec[%s]", new Object[]{segmentGranularity, i, actualSpecs.get(i)});
                    }
                    shardSpecs.put(segmentGranularity.getStartMillis(), actualSpecs);
                    continue;
                }
                log.info("Path[%s] didn't exist!?", new Object[]{partitionInfoPath});
            }
            this.config.setShardSpecs(shardSpecs);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getStats() {
        if (this.groupByJob == null) {
            return null;
        }
        try {
            Counters jobCounters = this.groupByJob.getCounters();
            return TaskMetricsUtils.makeIngestionRowMetrics((long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_WITH_ERRORS_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_UNPARSEABLE_COUNTER).getValue(), (long)jobCounters.findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_THROWN_AWAY_COUNTER).getValue());
        }
        catch (IllegalStateException ise) {
            log.debug("Couldn't get counters due to job state", new Object[0]);
            return null;
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Encountered exception in getStats().", new Object[0]);
            return null;
        }
    }

    @Nullable
    public String getErrorMessage() {
        return this.failureCause;
    }

    private static void write(TaskInputOutputContext<?, ?, BytesWritable, Text> context, byte[] groupKey, DimValueCount dimValueCount) throws IOException, InterruptedException {
        byte[] sortKey = TAB_JOINER.join((Object)dimValueCount.dim, (Object)dimValueCount.value, new Object[0]).getBytes(HadoopDruidIndexerConfig.JAVA_NATIVE_CHARSET);
        context.write((Object)new SortableBytes(groupKey, sortKey).toBytesWritable(), (Object)dimValueCount.toText());
    }

    private static class DimValueCount {
        public final String dim;
        public final String value;
        public final long numRows;

        private DimValueCount(String dim, String value, long numRows) {
            this.dim = dim;
            this.value = value;
            this.numRows = numRows;
        }

        Text toText() {
            return new Text(TAB_JOINER.join((Object)this.dim, (Object)String.valueOf(this.numRows), new Object[]{this.value}));
        }

        static DimValueCount fromText(Text text) {
            Iterator splits = TAB_SPLITTER.limit(3).split((CharSequence)text.toString()).iterator();
            String dim = (String)splits.next();
            long numRows = Long.parseLong((String)splits.next());
            String value = (String)splits.next();
            return new DimValueCount(dim, value, numRows);
        }
    }

    private static class DimPartition {
        @Nullable
        public ShardSpec shardSpec = null;
        int cardinality = 0;
        public long rows = 0L;

        private DimPartition() {
        }
    }

    private static class DimPartitions {
        public final String dim;
        public final List<DimPartition> partitions = new ArrayList<DimPartition>();

        private DimPartitions(String dim) {
            this.dim = dim;
        }

        int getCardinality() {
            int sum = 0;
            for (DimPartition dimPartition : this.partitions) {
                sum += dimPartition.cardinality;
            }
            return sum;
        }

        long getDistanceSquaredFromTarget(long target) {
            long distance = 0L;
            for (DimPartition dimPartition : this.partitions) {
                distance += (dimPartition.rows - target) * (dimPartition.rows - target);
            }
            return distance /= (long)this.partitions.size();
        }

        public long getRows() {
            long sum = 0L;
            for (DimPartition dimPartition : this.partitions) {
                sum += dimPartition.rows;
            }
            return sum;
        }
    }

    public static class DeterminePartitionsDimSelectionOutputFormat
    extends FileOutputFormat {
        public RecordWriter getRecordWriter(TaskAttemptContext job) {
            return new RecordWriter<SortableBytes, List<ShardSpec>>(){

                public void write(SortableBytes keyBytes, List<ShardSpec> partitions) {
                }

                public void close(TaskAttemptContext context) {
                }
            };
        }

        public void checkOutputSpecs(JobContext job) throws IOException {
            Path outDir = FileOutputFormat.getOutputPath((JobContext)job);
            if (outDir == null) {
                throw new InvalidJobConfException("Output directory not set.");
            }
        }
    }

    public static class DeterminePartitionsDimSelectionReducer
    extends DeterminePartitionsDimSelectionBaseReducer {
        private static final double SHARD_COMBINE_THRESHOLD = 0.25;
        private static final int HIGH_CARDINALITY_THRESHOLD = 3000000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void innerReduce(Reducer.Context context, SortableBytes keyBytes, Iterable<DimValueCount> combinedIterable) throws IOException {
            ByteBuffer groupKey = ByteBuffer.wrap(keyBytes.getGroupKey());
            groupKey.position(4);
            DateTime bucket = DateTimes.utc((long)groupKey.getLong());
            PeekingIterator iterator = Iterators.peekingIterator(combinedIterable.iterator());
            log.info("Determining partitions for interval: %s", new Object[]{this.config.getGranularitySpec().bucketInterval(bucket).orNull()});
            DimValueCount firstDvc = (DimValueCount)iterator.next();
            long totalRows = firstDvc.numRows;
            if (!"".equals(firstDvc.dim) || !"".equals(firstDvc.value)) {
                throw new IllegalStateException("Expected total row indicator on first k/v pair");
            }
            DimPartitions currentDimPartitions = null;
            DimPartition currentDimPartition = null;
            String currentDimPartitionStart = null;
            boolean currentDimSkip = false;
            HashMap<String, DimPartitions> dimPartitionss = new HashMap<String, DimPartitions>();
            while (iterator.hasNext()) {
                SingleDimensionShardSpec shardSpec;
                DimValueCount dvc = (DimValueCount)iterator.next();
                if (currentDimPartitions == null || !currentDimPartitions.dim.equals(dvc.dim)) {
                    currentDimPartitions = new DimPartitions(dvc.dim);
                    currentDimPartition = new DimPartition();
                    currentDimPartitionStart = null;
                    currentDimSkip = false;
                }
                if (!currentDimSkip && dvc.numRows < 0L) {
                    log.info("Cannot partition on multi-value dimension: %s", new Object[]{dvc.dim});
                    currentDimSkip = true;
                }
                if (currentDimSkip) continue;
                if (currentDimPartition.rows > 0L && currentDimPartition.rows + dvc.numRows > (long)this.config.getTargetPartitionSize()) {
                    shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, currentDimPartitionStart, dvc.value, currentDimPartitions.partitions.size(), Integer.valueOf(-1));
                    log.info("Adding possible shard with %,d rows and %,d unique values: %s", new Object[]{currentDimPartition.rows, currentDimPartition.cardinality, shardSpec});
                    currentDimPartition.shardSpec = shardSpec;
                    currentDimPartitions.partitions.add(currentDimPartition);
                    currentDimPartition = new DimPartition();
                    currentDimPartitionStart = dvc.value;
                }
                ++currentDimPartition.cardinality;
                currentDimPartition.rows += dvc.numRows;
                if (iterator.hasNext() && currentDimPartitions.dim.equals(((DimValueCount)iterator.peek()).dim)) continue;
                if (currentDimPartition.rows > 0L) {
                    if ((double)currentDimPartition.rows < (double)this.config.getTargetPartitionSize() * 0.25 && !currentDimPartitions.partitions.isEmpty()) {
                        DimPartition previousDimPartition = currentDimPartitions.partitions.remove(currentDimPartitions.partitions.size() - 1);
                        SingleDimensionShardSpec previousShardSpec = (SingleDimensionShardSpec)previousDimPartition.shardSpec;
                        shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, previousShardSpec.getStart(), null, previousShardSpec.getPartitionNum(), Integer.valueOf(-1));
                        log.info("Removing possible shard: %s", new Object[]{previousShardSpec});
                        currentDimPartition.rows += previousDimPartition.rows;
                        currentDimPartition.cardinality += previousDimPartition.cardinality;
                    } else {
                        shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, currentDimPartitionStart, null, currentDimPartitions.partitions.size(), Integer.valueOf(-1));
                    }
                    log.info("Adding possible shard with %,d rows and %,d unique values: %s", new Object[]{currentDimPartition.rows, currentDimPartition.cardinality, shardSpec});
                    currentDimPartition.shardSpec = shardSpec;
                    currentDimPartitions.partitions.add(currentDimPartition);
                }
                log.info("Completed dimension[%s]: %,d possible shards with %,d unique values", new Object[]{currentDimPartitions.dim, currentDimPartitions.partitions.size(), currentDimPartitions.getCardinality()});
                dimPartitionss.put(currentDimPartitions.dim, currentDimPartitions);
            }
            if (dimPartitionss.isEmpty()) {
                throw new ISE("No suitable partitioning dimension found!", new Object[0]);
            }
            int maxCardinality = Integer.MIN_VALUE;
            long minDistance = Long.MAX_VALUE;
            DimPartitions minDistancePartitions = null;
            DimPartitions maxCardinalityPartitions = null;
            for (DimPartitions dimPartitions : dimPartitionss.values()) {
                if (dimPartitions.getRows() != totalRows) {
                    log.info("Dimension[%s] is not present in all rows (row count %,d != expected row count %,d)", new Object[]{dimPartitions.dim, dimPartitions.getRows(), totalRows});
                    continue;
                }
                boolean oversized = false;
                SingleDimensionPartitionsSpec partitionsSpec = (SingleDimensionPartitionsSpec)this.config.getPartitionsSpec();
                for (DimPartition partition : dimPartitions.partitions) {
                    if (partition.rows <= (long)partitionsSpec.getMaxRowsPerSegment().intValue()) continue;
                    log.info("Dimension[%s] has an oversized shard: %s", new Object[]{dimPartitions.dim, partition.shardSpec});
                    oversized = true;
                }
                if (oversized) continue;
                int cardinality = dimPartitions.getCardinality();
                long distance = dimPartitions.getDistanceSquaredFromTarget(this.config.getTargetPartitionSize());
                if (cardinality > maxCardinality) {
                    maxCardinality = cardinality;
                    maxCardinalityPartitions = dimPartitions;
                }
                if (distance >= minDistance) continue;
                minDistance = distance;
                minDistancePartitions = dimPartitions;
            }
            if (maxCardinalityPartitions == null) {
                throw new ISE("No suitable partitioning dimension found!", new Object[0]);
            }
            OutputStream out = Utils.makePathAndOutputStream((JobContext)context, this.config.makeSegmentPartitionInfoPath((Interval)this.config.getGranularitySpec().bucketInterval(bucket).get()), this.config.isOverwriteFiles());
            DimPartitions chosenPartitions = maxCardinality > 3000000 ? maxCardinalityPartitions : minDistancePartitions;
            List chosenShardSpecs = Lists.transform(chosenPartitions.partitions, dimPartition -> dimPartition.shardSpec);
            log.info("Chosen partitions:", new Object[0]);
            for (ShardSpec shardSpec : chosenShardSpecs) {
                log.info("  %s", new Object[]{HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)shardSpec)});
            }
            try {
                HadoopDruidIndexerConfig.JSON_MAPPER.writerWithType((TypeReference)new TypeReference<List<ShardSpec>>(){}).writeValue(out, (Object)chosenShardSpecs);
            }
            finally {
                Closeables.close((Closeable)out, (boolean)false);
            }
        }
    }

    public static class DeterminePartitionsDimSelectionCombiner
    extends DeterminePartitionsDimSelectionBaseReducer {
        @Override
        protected void innerReduce(Reducer.Context context, SortableBytes keyBytes, Iterable<DimValueCount> combinedIterable) throws IOException, InterruptedException {
            for (DimValueCount dvc : combinedIterable) {
                DeterminePartitionsJob.write((TaskInputOutputContext)context, keyBytes.getGroupKey(), dvc);
            }
        }
    }

    private static abstract class DeterminePartitionsDimSelectionBaseReducer
    extends Reducer<BytesWritable, Text, BytesWritable, Text> {
        @Nullable
        protected volatile HadoopDruidIndexerConfig config = null;

        private DeterminePartitionsDimSelectionBaseReducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setup(Reducer.Context context) {
            if (this.config != null) return;
            Class<DeterminePartitionsDimSelectionBaseReducer> clazz = DeterminePartitionsDimSelectionBaseReducer.class;
            synchronized (DeterminePartitionsDimSelectionBaseReducer.class) {
                if (this.config != null) return;
                this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        protected void reduce(BytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            SortableBytes keyBytes = SortableBytes.fromBytesWritable(key);
            Iterable<DimValueCount> combinedIterable = DeterminePartitionsDimSelectionBaseReducer.combineRows(values);
            this.innerReduce(context, keyBytes, combinedIterable);
        }

        protected abstract void innerReduce(Reducer.Context var1, SortableBytes var2, Iterable<DimValueCount> var3) throws IOException, InterruptedException;

        private static Iterable<DimValueCount> combineRows(Iterable<Text> input) {
            return new CombiningIterable(Iterables.transform(input, DimValueCount::fromText), (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.dim), (Comparable)((Object)o2.dim)).compare((Comparable)((Object)o1.value), (Comparable)((Object)o2.value)).result(), (arg1, arg2) -> {
                if (arg2 == null) {
                    return arg1;
                }
                long newNumRows = arg1.numRows >= 0L && arg2.numRows >= 0L ? arg1.numRows + arg2.numRows : -1L;
                return new DimValueCount(arg1.dim, arg1.value, newNumRows);
            });
        }
    }

    public static class DeterminePartitionsDimSelectionPartitioner
    extends Partitioner<BytesWritable, Text>
    implements Configurable {
        private Configuration config;

        public int getPartition(BytesWritable bytesWritable, Text text, int numPartitions) {
            ByteBuffer bytes = ByteBuffer.wrap(bytesWritable.getBytes());
            bytes.position(4);
            int index = bytes.getInt();
            String jobTrackerAddress = JobHelper.getJobTrackerAddress(this.config);
            if ("local".equals(jobTrackerAddress)) {
                return index % numPartitions;
            }
            if (index >= numPartitions) {
                throw new ISE("Not enough partitions, index[%,d] >= numPartitions[%,d]. Please increase the number of reducers to the index size or check your config & settings!", new Object[]{index, numPartitions});
            }
            return index;
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
        }
    }

    static class DeterminePartitionsDimSelectionMapperHelper {
        private final HadoopDruidIndexerConfig config;
        private final String partitionDimension;
        private final Map<Long, Integer> intervalIndexes;

        DeterminePartitionsDimSelectionMapperHelper(HadoopDruidIndexerConfig config, String partitionDimension) {
            this.config = config;
            this.partitionDimension = partitionDimension;
            ImmutableMap.Builder timeIndexBuilder = ImmutableMap.builder();
            int idx = 0;
            for (Interval bucketInterval : config.getGranularitySpec().sortedBucketIntervals()) {
                timeIndexBuilder.put((Object)bucketInterval.getStartMillis(), (Object)idx);
                ++idx;
            }
            this.intervalIndexes = timeIndexBuilder.build();
        }

        void emitDimValueCounts(TaskInputOutputContext<?, ?, BytesWritable, Text> context, DateTime timestamp, Map<String, Iterable<String>> dims) throws IOException, InterruptedException {
            Optional maybeInterval = this.config.getGranularitySpec().bucketInterval(timestamp);
            if (!maybeInterval.isPresent()) {
                throw new ISE("No bucket found for timestamp: %s", new Object[]{timestamp});
            }
            Interval interval = (Interval)maybeInterval.get();
            int intervalIndex = this.intervalIndexes.get(interval.getStartMillis());
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.putInt(intervalIndex);
            buf.putLong(interval.getStartMillis());
            byte[] groupKey = buf.array();
            DeterminePartitionsJob.write(context, groupKey, new DimValueCount("", "", 1L));
            for (Map.Entry<String, Iterable<String>> dimAndValues : dims.entrySet()) {
                String dim = dimAndValues.getKey();
                if (this.partitionDimension != null && !this.partitionDimension.equals(dim)) continue;
                Iterable<String> dimValues = dimAndValues.getValue();
                if (Iterables.size(dimValues) == 1) {
                    DeterminePartitionsJob.write(context, groupKey, new DimValueCount(dim, (String)Iterables.getOnlyElement(dimValues), 1L));
                    continue;
                }
                DeterminePartitionsJob.write(context, groupKey, new DimValueCount(dim, "", -1L));
            }
        }
    }

    public static class DeterminePartitionsDimSelectionAssumeGroupedMapper
    extends HadoopDruidIndexerMapper<BytesWritable, Text> {
        private DeterminePartitionsDimSelectionMapperHelper helper;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            SingleDimensionPartitionsSpec spec = (SingleDimensionPartitionsSpec)config.getPartitionsSpec();
            this.helper = new DeterminePartitionsDimSelectionMapperHelper(config, spec.getPartitionDimension());
        }

        @Override
        protected void innerMap(InputRow inputRow, Mapper.Context context) throws IOException, InterruptedException {
            HashMap<String, Iterable<String>> dims = new HashMap<String, Iterable<String>>();
            for (String dim : inputRow.getDimensions()) {
                dims.put(dim, inputRow.getDimension(dim));
            }
            this.helper.emitDimValueCounts((TaskInputOutputContext<?, ?, BytesWritable, Text>)context, DateTimes.utc((long)inputRow.getTimestampFromEpoch()), (Map<String, Iterable<String>>)dims);
        }
    }

    public static class DeterminePartitionsDimSelectionPostGroupByMapper
    extends Mapper<BytesWritable, NullWritable, BytesWritable, Text> {
        @Nullable
        private DeterminePartitionsDimSelectionMapperHelper helper;

        protected void setup(Mapper.Context context) {
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            SingleDimensionPartitionsSpec spec = (SingleDimensionPartitionsSpec)config.getPartitionsSpec();
            this.helper = new DeterminePartitionsDimSelectionMapperHelper(config, spec.getPartitionDimension());
        }

        protected void map(BytesWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            List timeAndDims = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(key.getBytes(), List.class);
            DateTime timestamp = new DateTime(timeAndDims.get(0), (Chronology)ISOChronology.getInstanceUTC());
            Map dims = (Map)timeAndDims.get(1);
            this.helper.emitDimValueCounts((TaskInputOutputContext<?, ?, BytesWritable, Text>)context, timestamp, dims);
        }
    }

    public static class DeterminePartitionsGroupByReducer
    extends Reducer<BytesWritable, NullWritable, BytesWritable, NullWritable> {
        protected void reduce(BytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static class DeterminePartitionsGroupByMapper
    extends HadoopDruidIndexerMapper<BytesWritable, NullWritable> {
        @Nullable
        private Granularity rollupGranularity = null;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.rollupGranularity = this.getConfig().getGranularitySpec().getQueryGranularity();
        }

        @Override
        protected void innerMap(InputRow inputRow, Mapper.Context context) throws IOException, InterruptedException {
            List groupKey = Rows.toGroupKey((long)this.rollupGranularity.bucketStart(inputRow.getTimestamp()).getMillis(), (InputRow)inputRow);
            context.write((Object)new BytesWritable(HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsBytes((Object)groupKey)), (Object)NullWritable.get());
            context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.ROWS_PROCESSED_COUNTER).increment(1L);
        }
    }
}

