/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.path.PathSpec;
import org.apache.hadoop.mapreduce.Job;

public class MultiplePathSpec
implements PathSpec {
    private List<PathSpec> children;

    public MultiplePathSpec(@JsonProperty(value="children") List<PathSpec> children) {
        Preconditions.checkArgument((children != null && children.size() > 0 ? 1 : 0) != 0, (Object)"Null/Empty list of child PathSpecs");
        this.children = children;
    }

    @JsonProperty
    public List<PathSpec> getChildren() {
        return this.children;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        for (PathSpec spec : this.children) {
            spec.addInputPaths(config, job);
        }
        return job;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiplePathSpec that = (MultiplePathSpec)o;
        return this.children.equals(that.children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }
}

