/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;

public class SortableBytes {
    private final byte[] groupKey;
    private final byte[] sortKey;

    public SortableBytes(byte[] groupKey, byte[] sortKey) {
        this.groupKey = groupKey;
        this.sortKey = sortKey;
    }

    public byte[] getGroupKey() {
        return this.groupKey;
    }

    public byte[] getSortKey() {
        return this.sortKey;
    }

    public byte[] toBytes() {
        ByteBuffer outBytes = ByteBuffer.wrap(new byte[4 + this.groupKey.length + this.sortKey.length]);
        outBytes.putInt(this.groupKey.length);
        outBytes.put(this.groupKey);
        outBytes.put(this.sortKey);
        return outBytes.array();
    }

    public BytesWritable toBytesWritable() {
        return new BytesWritable(this.toBytes());
    }

    public String toString() {
        return "SortableBytes{groupKey='" + StringUtils.fromUtf8((byte[])this.groupKey) + "', sortKey='" + StringUtils.fromUtf8((byte[])this.sortKey) + "'}";
    }

    public static SortableBytes fromBytesWritable(BytesWritable bytes) {
        return SortableBytes.fromBytes(bytes.getBytes(), 0, bytes.getLength());
    }

    public static SortableBytes fromBytes(byte[] bytes, int offset, int length) {
        int groupKeySize = ByteBuffer.wrap(bytes, offset, length).getInt();
        int sortKeyOffset = offset + 4 + groupKeySize;
        return new SortableBytes(Arrays.copyOfRange(bytes, offset + 4, sortKeyOffset), Arrays.copyOfRange(bytes, sortKeyOffset, offset + length));
    }

    public static void useSortableBytesAsMapOutputKey(Job job, Class<? extends Partitioner> partitionerClass) {
        job.setMapOutputKeyClass(BytesWritable.class);
        job.setGroupingComparatorClass(SortableBytesGroupingComparator.class);
        job.setSortComparatorClass(SortableBytesSortingComparator.class);
        job.setPartitionerClass(partitionerClass);
    }

    public static class SortableBytesSortingComparator
    extends WritableComparator {
        protected SortableBytesSortingComparator() {
            super(BytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int b2Length;
            int b1Length = ByteBuffer.wrap(b1, s1 + 4, l1 - 4).getInt();
            int retVal = SortableBytesSortingComparator.compareBytes((byte[])b1, (int)(s1 + 8), (int)b1Length, (byte[])b2, (int)(s2 + 8), (int)(b2Length = ByteBuffer.wrap(b2, s2 + 4, l2 - 4).getInt()));
            if (retVal == 0) {
                retVal = SortableBytesSortingComparator.compareBytes((byte[])b1, (int)(s1 + 8 + b1Length), (int)(l1 - 8 - b1Length), (byte[])b2, (int)(s2 + 8 + b2Length), (int)(l2 - 8 - b2Length));
            }
            return retVal;
        }
    }

    public static class SortableBytesGroupingComparator
    extends WritableComparator {
        protected SortableBytesGroupingComparator() {
            super(BytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int b1Length = ByteBuffer.wrap(b1, s1 + 4, l1 - 4).getInt();
            int b2Length = ByteBuffer.wrap(b2, s2 + 4, l2 - 4).getInt();
            int retVal = SortableBytesGroupingComparator.compareBytes((byte[])b1, (int)(s1 + 8), (int)b1Length, (byte[])b2, (int)(s2 + 8), (int)b2Length);
            return retVal;
        }
    }
}

