/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.path;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.indexer.path.CharStream;

public class HadoopGlobPathSplitter {
    public static Iterable<String> splitGlob(String path) {
        return Iterables.transform(HadoopGlobPathSplitter.splitGlob(new CharStream(path)), (Function)Functions.toStringFunction());
    }

    private static List<StringBuilder> splitGlob(CharStream path) {
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> current = new ArrayList<StringBuilder>();
        current.add(new StringBuilder());
        block5: while (path.hasMore()) {
            char c = path.next();
            switch (c) {
                case '{': {
                    List<StringBuilder> childResult = HadoopGlobPathSplitter.splitGlob(path);
                    ArrayList<StringBuilder> oldCurrent = current;
                    current = new ArrayList();
                    for (StringBuilder sb1 : oldCurrent) {
                        for (StringBuilder sb2 : childResult) {
                            StringBuilder sb3 = new StringBuilder();
                            sb3.append((CharSequence)sb1);
                            sb3.append((CharSequence)sb2);
                            current.add(sb3);
                        }
                    }
                    continue block5;
                }
                case '}': {
                    result.addAll(current);
                    return result;
                }
                case ',': {
                    result.addAll(current);
                    current = new ArrayList();
                    current.add(new StringBuilder());
                    break;
                }
                default: {
                    for (StringBuilder sb : current) {
                        sb.append(c);
                    }
                    continue block5;
                }
            }
        }
        result.addAll(current);
        return result;
    }
}

